<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Touchpoint StructType
 * @subpackage Structs
 */
class Touchpoint extends AbstractStructBase
{
    /**
     * The affiliateSiteID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $affiliateSiteID;
    /**
     * The siteType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $siteType;
    /**
     * The registrationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $registrationDate;
    /**
     * The numImpressions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $numImpressions;
    /**
     * The numClicks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $numClicks;
    /**
     * The isAttributed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var bool
     */
    public $isAttributed;
    /**
     * The commission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var float
     */
    public $commission;
    /**
     * The position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $position;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $reference;
    /**
     * Constructor method for Touchpoint
     * @uses Touchpoint::setAffiliateSiteID()
     * @uses Touchpoint::setSiteType()
     * @uses Touchpoint::setRegistrationDate()
     * @uses Touchpoint::setNumImpressions()
     * @uses Touchpoint::setNumClicks()
     * @uses Touchpoint::setIsAttributed()
     * @uses Touchpoint::setCommission()
     * @uses Touchpoint::setPosition()
     * @uses Touchpoint::setReference()
     * @param int $affiliateSiteID
     * @param string $siteType
     * @param string $registrationDate
     * @param int $numImpressions
     * @param int $numClicks
     * @param bool $isAttributed
     * @param float $commission
     * @param string $position
     * @param string $reference
     */
    public function __construct($affiliateSiteID = null, $siteType = null, $registrationDate = null, $numImpressions = null, $numClicks = null, $isAttributed = null, $commission = null, $position = null, $reference = null)
    {
        $this
            ->setAffiliateSiteID($affiliateSiteID)
            ->setSiteType($siteType)
            ->setRegistrationDate($registrationDate)
            ->setNumImpressions($numImpressions)
            ->setNumClicks($numClicks)
            ->setIsAttributed($isAttributed)
            ->setCommission($commission)
            ->setPosition($position)
            ->setReference($reference);
    }
    /**
     * Get affiliateSiteID value
     * @return int|null
     */
    public function getAffiliateSiteID()
    {
        return $this->affiliateSiteID;
    }
    /**
     * Set affiliateSiteID value
     * @param int $affiliateSiteID
     * @return \StructType\Touchpoint
     */
    public function setAffiliateSiteID($affiliateSiteID = null)
    {
        // validation for constraint: int
        if (!is_null($affiliateSiteID) && !(is_int($affiliateSiteID) || ctype_digit($affiliateSiteID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($affiliateSiteID, true), gettype($affiliateSiteID)), __LINE__);
        }
        $this->affiliateSiteID = $affiliateSiteID;
        return $this;
    }
    /**
     * Get siteType value
     * @return string|null
     */
    public function getSiteType()
    {
        return $this->siteType;
    }
    /**
     * Set siteType value
     * @param string $siteType
     * @return \StructType\Touchpoint
     */
    public function setSiteType($siteType = null)
    {
        // validation for constraint: string
        if (!is_null($siteType) && !is_string($siteType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteType, true), gettype($siteType)), __LINE__);
        }
        $this->siteType = $siteType;
        return $this;
    }
    /**
     * Get registrationDate value
     * @return string|null
     */
    public function getRegistrationDate()
    {
        return $this->registrationDate;
    }
    /**
     * Set registrationDate value
     * @param string $registrationDate
     * @return \StructType\Touchpoint
     */
    public function setRegistrationDate($registrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDate) && !is_string($registrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationDate, true), gettype($registrationDate)), __LINE__);
        }
        $this->registrationDate = $registrationDate;
        return $this;
    }
    /**
     * Get numImpressions value
     * @return int|null
     */
    public function getNumImpressions()
    {
        return $this->numImpressions;
    }
    /**
     * Set numImpressions value
     * @param int $numImpressions
     * @return \StructType\Touchpoint
     */
    public function setNumImpressions($numImpressions = null)
    {
        // validation for constraint: int
        if (!is_null($numImpressions) && !(is_int($numImpressions) || ctype_digit($numImpressions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numImpressions, true), gettype($numImpressions)), __LINE__);
        }
        $this->numImpressions = $numImpressions;
        return $this;
    }
    /**
     * Get numClicks value
     * @return int|null
     */
    public function getNumClicks()
    {
        return $this->numClicks;
    }
    /**
     * Set numClicks value
     * @param int $numClicks
     * @return \StructType\Touchpoint
     */
    public function setNumClicks($numClicks = null)
    {
        // validation for constraint: int
        if (!is_null($numClicks) && !(is_int($numClicks) || ctype_digit($numClicks))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numClicks, true), gettype($numClicks)), __LINE__);
        }
        $this->numClicks = $numClicks;
        return $this;
    }
    /**
     * Get isAttributed value
     * @return bool|null
     */
    public function getIsAttributed()
    {
        return $this->isAttributed;
    }
    /**
     * Set isAttributed value
     * @param bool $isAttributed
     * @return \StructType\Touchpoint
     */
    public function setIsAttributed($isAttributed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAttributed) && !is_bool($isAttributed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAttributed, true), gettype($isAttributed)), __LINE__);
        }
        $this->isAttributed = $isAttributed;
        return $this;
    }
    /**
     * Get commission value
     * @return float|null
     */
    public function getCommission()
    {
        return $this->commission;
    }
    /**
     * Set commission value
     * @param float $commission
     * @return \StructType\Touchpoint
     */
    public function setCommission($commission = null)
    {
        // validation for constraint: float
        if (!is_null($commission) && !(is_float($commission) || is_numeric($commission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commission, true), gettype($commission)), __LINE__);
        }
        $this->commission = $commission;
        return $this;
    }
    /**
     * Get position value
     * @return string|null
     */
    public function getPosition()
    {
        return $this->position;
    }
    /**
     * Set position value
     * @param string $position
     * @return \StructType\Touchpoint
     */
    public function setPosition($position = null)
    {
        // validation for constraint: string
        if (!is_null($position) && !is_string($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($position, true), gettype($position)), __LINE__);
        }
        $this->position = $position;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\Touchpoint
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
}
