<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignCommissionExtended StructType
 * @subpackage Structs
 */
class CampaignCommissionExtended extends AbstractStructBase
{
    /**
     * The impressionCommission
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var float
     */
    public $impressionCommission;
    /**
     * The clickCommission
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var float
     */
    public $clickCommission;
    /**
     * The fixedCommission
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var float
     */
    public $fixedCommission;
    /**
     * The products
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - arrayType: tns:CampaignCommissionProduct[]
     * - ref: SOAP-ENC:arrayType
     * @var \StructType\CampaignCommissionProduct[]
     */
    public $products;
    /**
     * Constructor method for CampaignCommissionExtended
     * @uses CampaignCommissionExtended::setImpressionCommission()
     * @uses CampaignCommissionExtended::setClickCommission()
     * @uses CampaignCommissionExtended::setFixedCommission()
     * @uses CampaignCommissionExtended::setProducts()
     * @param float $impressionCommission
     * @param float $clickCommission
     * @param float $fixedCommission
     * @param \StructType\CampaignCommissionProduct[] $products
     */
    public function __construct($impressionCommission = null, $clickCommission = null, $fixedCommission = null, array $products = array())
    {
        $this
            ->setImpressionCommission($impressionCommission)
            ->setClickCommission($clickCommission)
            ->setFixedCommission($fixedCommission)
            ->setProducts($products);
    }
    /**
     * Get impressionCommission value
     * @return float|null
     */
    public function getImpressionCommission()
    {
        return $this->impressionCommission;
    }
    /**
     * Set impressionCommission value
     * @param float $impressionCommission
     * @return \StructType\CampaignCommissionExtended
     */
    public function setImpressionCommission($impressionCommission = null)
    {
        $this->impressionCommission = $impressionCommission;
        return $this;
    }
    /**
     * Get clickCommission value
     * @return float|null
     */
    public function getClickCommission()
    {
        return $this->clickCommission;
    }
    /**
     * Set clickCommission value
     * @param float $clickCommission
     * @return \StructType\CampaignCommissionExtended
     */
    public function setClickCommission($clickCommission = null)
    {
        $this->clickCommission = $clickCommission;
        return $this;
    }
    /**
     * Get fixedCommission value
     * @return float|null
     */
    public function getFixedCommission()
    {
        return $this->fixedCommission;
    }
    /**
     * Set fixedCommission value
     * @param float $fixedCommission
     * @return \StructType\CampaignCommissionExtended
     */
    public function setFixedCommission($fixedCommission = null)
    {
        $this->fixedCommission = $fixedCommission;
        return $this;
    }
    /**
     * Get products value
     * @return \StructType\CampaignCommissionProduct[]|null
     */
    public function getProducts()
    {
        return $this->products;
    }
    /**
     * Set products value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignCommissionProduct[] $products
     * @return \StructType\CampaignCommissionExtended
     */
    public function setProducts(array $products = array())
    {
        foreach ($products as $campaignCommissionExtendedProductsItem) {
            // validation for constraint: itemType
            if (!$campaignCommissionExtendedProductsItem instanceof \StructType\CampaignCommissionProduct) {
                throw new \InvalidArgumentException(sprintf('The products property can only contain items of \StructType\CampaignCommissionProduct, "%s" given', is_object($campaignCommissionExtendedProductsItem) ? get_class($campaignCommissionExtendedProductsItem) : gettype($campaignCommissionExtendedProductsItem)), __LINE__);
            }
        }
        $this->products = $products;
        return $this;
    }
    /**
     * Add item to products value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignCommissionProduct $item
     * @return \StructType\CampaignCommissionExtended
     */
    public function addToProducts(\StructType\CampaignCommissionProduct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CampaignCommissionProduct) {
            throw new \InvalidArgumentException(sprintf('The products property can only contain items of \StructType\CampaignCommissionProduct, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->products[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CampaignCommissionExtended
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
