<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConversionTransaction StructType
 * @subpackage Structs
 */
class ConversionTransaction extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The campaign
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var \StructType\Campaign
     */
    public $campaign;
    /**
     * The campaignProduct
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var \StructType\CampaignProduct
     */
    public $campaignProduct;
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $reference;
    /**
     * The transactionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $transactionType;
    /**
     * The transactionStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $transactionStatus;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * The commission
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var float
     */
    public $commission;
    /**
     * The orderAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var float
     */
    public $orderAmount;
    /**
     * The IP
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $IP;
    /**
     * The registrationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $registrationDate;
    /**
     * The assessmentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $assessmentDate;
    /**
     * The clickToConversion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $clickToConversion;
    /**
     * The originatingClickDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $originatingClickDate;
    /**
     * The rejectionReason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $rejectionReason;
    /**
     * The paidOut
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var bool
     */
    public $paidOut;
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $countryCode;
    /**
     * Constructor method for ConversionTransaction
     * @uses ConversionTransaction::setID()
     * @uses ConversionTransaction::setCampaign()
     * @uses ConversionTransaction::setCampaignProduct()
     * @uses ConversionTransaction::setReference()
     * @uses ConversionTransaction::setTransactionType()
     * @uses ConversionTransaction::setTransactionStatus()
     * @uses ConversionTransaction::setDescription()
     * @uses ConversionTransaction::setCurrency()
     * @uses ConversionTransaction::setCommission()
     * @uses ConversionTransaction::setOrderAmount()
     * @uses ConversionTransaction::setIP()
     * @uses ConversionTransaction::setRegistrationDate()
     * @uses ConversionTransaction::setAssessmentDate()
     * @uses ConversionTransaction::setClickToConversion()
     * @uses ConversionTransaction::setOriginatingClickDate()
     * @uses ConversionTransaction::setRejectionReason()
     * @uses ConversionTransaction::setPaidOut()
     * @uses ConversionTransaction::setCountryCode()
     * @param int $iD
     * @param \StructType\Campaign $campaign
     * @param \StructType\CampaignProduct $campaignProduct
     * @param string $reference
     * @param string $transactionType
     * @param string $transactionStatus
     * @param string $description
     * @param string $currency
     * @param float $commission
     * @param float $orderAmount
     * @param string $iP
     * @param string $registrationDate
     * @param string $assessmentDate
     * @param string $clickToConversion
     * @param string $originatingClickDate
     * @param string $rejectionReason
     * @param bool $paidOut
     * @param string $countryCode
     */
    public function __construct($iD = null, \StructType\Campaign $campaign = null, \StructType\CampaignProduct $campaignProduct = null, $reference = null, $transactionType = null, $transactionStatus = null, $description = null, $currency = null, $commission = null, $orderAmount = null, $iP = null, $registrationDate = null, $assessmentDate = null, $clickToConversion = null, $originatingClickDate = null, $rejectionReason = null, $paidOut = null, $countryCode = null)
    {
        $this
            ->setID($iD)
            ->setCampaign($campaign)
            ->setCampaignProduct($campaignProduct)
            ->setReference($reference)
            ->setTransactionType($transactionType)
            ->setTransactionStatus($transactionStatus)
            ->setDescription($description)
            ->setCurrency($currency)
            ->setCommission($commission)
            ->setOrderAmount($orderAmount)
            ->setIP($iP)
            ->setRegistrationDate($registrationDate)
            ->setAssessmentDate($assessmentDate)
            ->setClickToConversion($clickToConversion)
            ->setOriginatingClickDate($originatingClickDate)
            ->setRejectionReason($rejectionReason)
            ->setPaidOut($paidOut)
            ->setCountryCode($countryCode);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\ConversionTransaction
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get campaign value
     * @return \StructType\Campaign|null
     */
    public function getCampaign()
    {
        return $this->campaign;
    }
    /**
     * Set campaign value
     * @param \StructType\Campaign $campaign
     * @return \StructType\ConversionTransaction
     */
    public function setCampaign(\StructType\Campaign $campaign = null)
    {
        $this->campaign = $campaign;
        return $this;
    }
    /**
     * Get campaignProduct value
     * @return \StructType\CampaignProduct|null
     */
    public function getCampaignProduct()
    {
        return $this->campaignProduct;
    }
    /**
     * Set campaignProduct value
     * @param \StructType\CampaignProduct $campaignProduct
     * @return \StructType\ConversionTransaction
     */
    public function setCampaignProduct(\StructType\CampaignProduct $campaignProduct = null)
    {
        $this->campaignProduct = $campaignProduct;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\ConversionTransaction
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get transactionType value
     * @return string|null
     */
    public function getTransactionType()
    {
        return $this->transactionType;
    }
    /**
     * Set transactionType value
     * @uses \EnumType\TransactionType::valueIsValid()
     * @uses \EnumType\TransactionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionType
     * @return \StructType\ConversionTransaction
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionType::valueIsValid($transactionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transactionType, implode(', ', \EnumType\TransactionType::getValidValues())), __LINE__);
        }
        $this->transactionType = $transactionType;
        return $this;
    }
    /**
     * Get transactionStatus value
     * @return string|null
     */
    public function getTransactionStatus()
    {
        return $this->transactionStatus;
    }
    /**
     * Set transactionStatus value
     * @uses \EnumType\TransactionStatus::valueIsValid()
     * @uses \EnumType\TransactionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionStatus
     * @return \StructType\ConversionTransaction
     */
    public function setTransactionStatus($transactionStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionStatus::valueIsValid($transactionStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transactionStatus, implode(', ', \EnumType\TransactionStatus::getValidValues())), __LINE__);
        }
        $this->transactionStatus = $transactionStatus;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ConversionTransaction
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\ConversionTransaction
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get commission value
     * @return float|null
     */
    public function getCommission()
    {
        return $this->commission;
    }
    /**
     * Set commission value
     * @param float $commission
     * @return \StructType\ConversionTransaction
     */
    public function setCommission($commission = null)
    {
        $this->commission = $commission;
        return $this;
    }
    /**
     * Get orderAmount value
     * @return float|null
     */
    public function getOrderAmount()
    {
        return $this->orderAmount;
    }
    /**
     * Set orderAmount value
     * @param float $orderAmount
     * @return \StructType\ConversionTransaction
     */
    public function setOrderAmount($orderAmount = null)
    {
        $this->orderAmount = $orderAmount;
        return $this;
    }
    /**
     * Get IP value
     * @return string|null
     */
    public function getIP()
    {
        return $this->IP;
    }
    /**
     * Set IP value
     * @param string $iP
     * @return \StructType\ConversionTransaction
     */
    public function setIP($iP = null)
    {
        // validation for constraint: string
        if (!is_null($iP) && !is_string($iP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iP)), __LINE__);
        }
        $this->IP = $iP;
        return $this;
    }
    /**
     * Get registrationDate value
     * @return string|null
     */
    public function getRegistrationDate()
    {
        return $this->registrationDate;
    }
    /**
     * Set registrationDate value
     * @param string $registrationDate
     * @return \StructType\ConversionTransaction
     */
    public function setRegistrationDate($registrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDate) && !is_string($registrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationDate)), __LINE__);
        }
        $this->registrationDate = $registrationDate;
        return $this;
    }
    /**
     * Get assessmentDate value
     * @return string|null
     */
    public function getAssessmentDate()
    {
        return $this->assessmentDate;
    }
    /**
     * Set assessmentDate value
     * @param string $assessmentDate
     * @return \StructType\ConversionTransaction
     */
    public function setAssessmentDate($assessmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($assessmentDate) && !is_string($assessmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($assessmentDate)), __LINE__);
        }
        $this->assessmentDate = $assessmentDate;
        return $this;
    }
    /**
     * Get clickToConversion value
     * @return string|null
     */
    public function getClickToConversion()
    {
        return $this->clickToConversion;
    }
    /**
     * Set clickToConversion value
     * @param string $clickToConversion
     * @return \StructType\ConversionTransaction
     */
    public function setClickToConversion($clickToConversion = null)
    {
        // validation for constraint: string
        if (!is_null($clickToConversion) && !is_string($clickToConversion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clickToConversion)), __LINE__);
        }
        $this->clickToConversion = $clickToConversion;
        return $this;
    }
    /**
     * Get originatingClickDate value
     * @return string|null
     */
    public function getOriginatingClickDate()
    {
        return $this->originatingClickDate;
    }
    /**
     * Set originatingClickDate value
     * @param string $originatingClickDate
     * @return \StructType\ConversionTransaction
     */
    public function setOriginatingClickDate($originatingClickDate = null)
    {
        // validation for constraint: string
        if (!is_null($originatingClickDate) && !is_string($originatingClickDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originatingClickDate)), __LINE__);
        }
        $this->originatingClickDate = $originatingClickDate;
        return $this;
    }
    /**
     * Get rejectionReason value
     * @return string|null
     */
    public function getRejectionReason()
    {
        return $this->rejectionReason;
    }
    /**
     * Set rejectionReason value
     * @uses \EnumType\TransactionRejectionReason::valueIsValid()
     * @uses \EnumType\TransactionRejectionReason::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rejectionReason
     * @return \StructType\ConversionTransaction
     */
    public function setRejectionReason($rejectionReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionRejectionReason::valueIsValid($rejectionReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rejectionReason, implode(', ', \EnumType\TransactionRejectionReason::getValidValues())), __LINE__);
        }
        $this->rejectionReason = $rejectionReason;
        return $this;
    }
    /**
     * Get paidOut value
     * @return bool|null
     */
    public function getPaidOut()
    {
        return $this->paidOut;
    }
    /**
     * Set paidOut value
     * @param bool $paidOut
     * @return \StructType\ConversionTransaction
     */
    public function setPaidOut($paidOut = null)
    {
        $this->paidOut = $paidOut;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \StructType\ConversionTransaction
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConversionTransaction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
