<?php

namespace EnumType;

/**
 * This class stands for AffiliateSiteStatus EnumType
 * @subpackage Enumerations
 */
class AffiliateSiteStatus
{
    /**
     * Constant for value 'pending'
     * @return string 'pending'
     */
    const VALUE_PENDING = 'pending';
    /**
     * Constant for value 'accepted'
     * @return string 'accepted'
     */
    const VALUE_ACCEPTED = 'accepted';
    /**
     * Constant for value 'rejected'
     * @return string 'rejected'
     */
    const VALUE_REJECTED = 'rejected';
    /**
     * Constant for value 'onhold'
     * @return string 'onhold'
     */
    const VALUE_ONHOLD = 'onhold';
    /**
     * Constant for value 'signedout'
     * @return string 'signedout'
     */
    const VALUE_SIGNEDOUT = 'signedout';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_ACCEPTED
     * @uses self::VALUE_REJECTED
     * @uses self::VALUE_ONHOLD
     * @uses self::VALUE_SIGNEDOUT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PENDING,
            self::VALUE_ACCEPTED,
            self::VALUE_REJECTED,
            self::VALUE_ONHOLD,
            self::VALUE_SIGNEDOUT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
