<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WooOrderLine StructType
 * @subpackage Structs
 */
class WooOrderLine extends AbstractStructBase
{
    /**
     * The orderid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $orderid;
    /**
     * The catalogId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $catalogId;
    /**
     * The numitems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $numitems;
    /**
     * The unitprice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $unitprice;
    /**
     * The productItemNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $productItemNumber;
    /**
     * Constructor method for WooOrderLine
     * @uses WooOrderLine::setOrderid()
     * @uses WooOrderLine::setCatalogId()
     * @uses WooOrderLine::setNumitems()
     * @uses WooOrderLine::setUnitprice()
     * @uses WooOrderLine::setProductItemNumber()
     * @param int $orderid
     * @param int $catalogId
     * @param int $numitems
     * @param float $unitprice
     * @param string $productItemNumber
     */
    public function __construct($orderid = null, $catalogId = null, $numitems = null, $unitprice = null, $productItemNumber = null)
    {
        $this
            ->setOrderid($orderid)
            ->setCatalogId($catalogId)
            ->setNumitems($numitems)
            ->setUnitprice($unitprice)
            ->setProductItemNumber($productItemNumber);
    }
    /**
     * Get orderid value
     * @return int
     */
    public function getOrderid()
    {
        return $this->orderid;
    }
    /**
     * Set orderid value
     * @param int $orderid
     * @return \StructType\WooOrderLine
     */
    public function setOrderid($orderid = null)
    {
        // validation for constraint: int
        if (!is_null($orderid) && !(is_int($orderid) || ctype_digit($orderid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderid, true), gettype($orderid)), __LINE__);
        }
        $this->orderid = $orderid;
        return $this;
    }
    /**
     * Get catalogId value
     * @return int
     */
    public function getCatalogId()
    {
        return $this->catalogId;
    }
    /**
     * Set catalogId value
     * @param int $catalogId
     * @return \StructType\WooOrderLine
     */
    public function setCatalogId($catalogId = null)
    {
        // validation for constraint: int
        if (!is_null($catalogId) && !(is_int($catalogId) || ctype_digit($catalogId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($catalogId, true), gettype($catalogId)), __LINE__);
        }
        $this->catalogId = $catalogId;
        return $this;
    }
    /**
     * Get numitems value
     * @return int
     */
    public function getNumitems()
    {
        return $this->numitems;
    }
    /**
     * Set numitems value
     * @param int $numitems
     * @return \StructType\WooOrderLine
     */
    public function setNumitems($numitems = null)
    {
        // validation for constraint: int
        if (!is_null($numitems) && !(is_int($numitems) || ctype_digit($numitems))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numitems, true), gettype($numitems)), __LINE__);
        }
        $this->numitems = $numitems;
        return $this;
    }
    /**
     * Get unitprice value
     * @return float
     */
    public function getUnitprice()
    {
        return $this->unitprice;
    }
    /**
     * Set unitprice value
     * @param float $unitprice
     * @return \StructType\WooOrderLine
     */
    public function setUnitprice($unitprice = null)
    {
        // validation for constraint: float
        if (!is_null($unitprice) && !(is_float($unitprice) || is_numeric($unitprice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitprice, true), gettype($unitprice)), __LINE__);
        }
        $this->unitprice = $unitprice;
        return $this;
    }
    /**
     * Get productItemNumber value
     * @return string|null
     */
    public function getProductItemNumber()
    {
        return $this->productItemNumber;
    }
    /**
     * Set productItemNumber value
     * @param string $productItemNumber
     * @return \StructType\WooOrderLine
     */
    public function setProductItemNumber($productItemNumber = null)
    {
        // validation for constraint: string
        if (!is_null($productItemNumber) && !is_string($productItemNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productItemNumber, true), gettype($productItemNumber)), __LINE__);
        }
        $this->productItemNumber = $productItemNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WooOrderLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
