<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for datosEntradaCursoCia StructType
 * @subpackage Structs
 */
class DatosEntradaCursoCia extends AbstractStructBase
{
    /**
     * The ciudadCia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ciudadCia;
    /**
     * The codigoCia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigoCia;
    /**
     * The codigoCurso
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigoCurso;
    /**
     * The codigoSedeCia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigoSedeCia;
    /**
     * The codigoTransaccion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigoTransaccion;
    /**
     * The comparendos
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CursoComparendo[]
     */
    public $comparendos;
    /**
     * The direccionAdquiriente
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $direccionAdquiriente;
    /**
     * The fechaRealizacionCurso
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fechaRealizacionCurso;
    /**
     * The fechaTransaccion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fechaTransaccion;
    /**
     * The funcionarioRegistra
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $funcionarioRegistra;
    /**
     * The horaFinCurso
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $horaFinCurso;
    /**
     * The horaInicioCurso
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $horaInicioCurso;
    /**
     * The horaTransaccion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $horaTransaccion;
    /**
     * The identificacionInfractor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $identificacionInfractor;
    /**
     * The identificacionInstructor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $identificacionInstructor;
    /**
     * The numeroSecuencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numeroSecuencia;
    /**
     * The tipoIdentificacion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoIdentificacion;
    /**
     * Constructor method for datosEntradaCursoCia
     * @uses DatosEntradaCursoCia::setCiudadCia()
     * @uses DatosEntradaCursoCia::setCodigoCia()
     * @uses DatosEntradaCursoCia::setCodigoCurso()
     * @uses DatosEntradaCursoCia::setCodigoSedeCia()
     * @uses DatosEntradaCursoCia::setCodigoTransaccion()
     * @uses DatosEntradaCursoCia::setComparendos()
     * @uses DatosEntradaCursoCia::setDireccionAdquiriente()
     * @uses DatosEntradaCursoCia::setFechaRealizacionCurso()
     * @uses DatosEntradaCursoCia::setFechaTransaccion()
     * @uses DatosEntradaCursoCia::setFuncionarioRegistra()
     * @uses DatosEntradaCursoCia::setHoraFinCurso()
     * @uses DatosEntradaCursoCia::setHoraInicioCurso()
     * @uses DatosEntradaCursoCia::setHoraTransaccion()
     * @uses DatosEntradaCursoCia::setIdentificacionInfractor()
     * @uses DatosEntradaCursoCia::setIdentificacionInstructor()
     * @uses DatosEntradaCursoCia::setNumeroSecuencia()
     * @uses DatosEntradaCursoCia::setTipoIdentificacion()
     * @param string $ciudadCia
     * @param string $codigoCia
     * @param string $codigoCurso
     * @param string $codigoSedeCia
     * @param string $codigoTransaccion
     * @param \StructType\CursoComparendo[] $comparendos
     * @param string $direccionAdquiriente
     * @param string $fechaRealizacionCurso
     * @param string $fechaTransaccion
     * @param string $funcionarioRegistra
     * @param string $horaFinCurso
     * @param string $horaInicioCurso
     * @param string $horaTransaccion
     * @param string $identificacionInfractor
     * @param string $identificacionInstructor
     * @param string $numeroSecuencia
     * @param string $tipoIdentificacion
     */
    public function __construct($ciudadCia = null, $codigoCia = null, $codigoCurso = null, $codigoSedeCia = null, $codigoTransaccion = null, array $comparendos = array(), $direccionAdquiriente = null, $fechaRealizacionCurso = null, $fechaTransaccion = null, $funcionarioRegistra = null, $horaFinCurso = null, $horaInicioCurso = null, $horaTransaccion = null, $identificacionInfractor = null, $identificacionInstructor = null, $numeroSecuencia = null, $tipoIdentificacion = null)
    {
        $this
            ->setCiudadCia($ciudadCia)
            ->setCodigoCia($codigoCia)
            ->setCodigoCurso($codigoCurso)
            ->setCodigoSedeCia($codigoSedeCia)
            ->setCodigoTransaccion($codigoTransaccion)
            ->setComparendos($comparendos)
            ->setDireccionAdquiriente($direccionAdquiriente)
            ->setFechaRealizacionCurso($fechaRealizacionCurso)
            ->setFechaTransaccion($fechaTransaccion)
            ->setFuncionarioRegistra($funcionarioRegistra)
            ->setHoraFinCurso($horaFinCurso)
            ->setHoraInicioCurso($horaInicioCurso)
            ->setHoraTransaccion($horaTransaccion)
            ->setIdentificacionInfractor($identificacionInfractor)
            ->setIdentificacionInstructor($identificacionInstructor)
            ->setNumeroSecuencia($numeroSecuencia)
            ->setTipoIdentificacion($tipoIdentificacion);
    }
    /**
     * Get ciudadCia value
     * @return string|null
     */
    public function getCiudadCia()
    {
        return $this->ciudadCia;
    }
    /**
     * Set ciudadCia value
     * @param string $ciudadCia
     * @return \StructType\DatosEntradaCursoCia
     */
    public function setCiudadCia($ciudadCia = null)
    {
        // validation for constraint: string
        if (!is_null($ciudadCia) && !is_string($ciudadCia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ciudadCia)), __LINE__);
        }
        $this->ciudadCia = $ciudadCia;
        return $this;
    }
    /**
     * Get codigoCia value
     * @return string|null
     */
    public function getCodigoCia()
    {
        return $this->codigoCia;
    }
    /**
     * Set codigoCia value
     * @param string $codigoCia
     * @return \StructType\DatosEntradaCursoCia
     */
    public function setCodigoCia($codigoCia = null)
    {
        // validation for constraint: string
        if (!is_null($codigoCia) && !is_string($codigoCia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoCia)), __LINE__);
        }
        $this->codigoCia = $codigoCia;
        return $this;
    }
    /**
     * Get codigoCurso value
     * @return string|null
     */
    public function getCodigoCurso()
    {
        return $this->codigoCurso;
    }
    /**
     * Set codigoCurso value
     * @param string $codigoCurso
     * @return \StructType\DatosEntradaCursoCia
     */
    public function setCodigoCurso($codigoCurso = null)
    {
        // validation for constraint: string
        if (!is_null($codigoCurso) && !is_string($codigoCurso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoCurso)), __LINE__);
        }
        $this->codigoCurso = $codigoCurso;
        return $this;
    }
    /**
     * Get codigoSedeCia value
     * @return string|null
     */
    public function getCodigoSedeCia()
    {
        return $this->codigoSedeCia;
    }
    /**
     * Set codigoSedeCia value
     * @param string $codigoSedeCia
     * @return \StructType\DatosEntradaCursoCia
     */
    public function setCodigoSedeCia($codigoSedeCia = null)
    {
        // validation for constraint: string
        if (!is_null($codigoSedeCia) && !is_string($codigoSedeCia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoSedeCia)), __LINE__);
        }
        $this->codigoSedeCia = $codigoSedeCia;
        return $this;
    }
    /**
     * Get codigoTransaccion value
     * @return string|null
     */
    public function getCodigoTransaccion()
    {
        return $this->codigoTransaccion;
    }
    /**
     * Set codigoTransaccion value
     * @param string $codigoTransaccion
     * @return \StructType\DatosEntradaCursoCia
     */
    public function setCodigoTransaccion($codigoTransaccion = null)
    {
        // validation for constraint: string
        if (!is_null($codigoTransaccion) && !is_string($codigoTransaccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoTransaccion)), __LINE__);
        }
        $this->codigoTransaccion = $codigoTransaccion;
        return $this;
    }
    /**
     * Get comparendos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CursoComparendo[]|null
     */
    public function getComparendos()
    {
        return isset($this->comparendos) ? $this->comparendos : null;
    }
    /**
     * Set comparendos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CursoComparendo[] $comparendos
     * @return \StructType\DatosEntradaCursoCia
     */
    public function setComparendos(array $comparendos = array())
    {
        foreach ($comparendos as $datosEntradaCursoCiaComparendosItem) {
            // validation for constraint: itemType
            if (!$datosEntradaCursoCiaComparendosItem instanceof \StructType\CursoComparendo) {
                throw new \InvalidArgumentException(sprintf('The comparendos property can only contain items of \StructType\CursoComparendo, "%s" given', is_object($datosEntradaCursoCiaComparendosItem) ? get_class($datosEntradaCursoCiaComparendosItem) : gettype($datosEntradaCursoCiaComparendosItem)), __LINE__);
            }
        }
        if (is_null($comparendos) || (is_array($comparendos) && empty($comparendos))) {
            unset($this->comparendos);
        } else {
            $this->comparendos = $comparendos;
        }
        return $this;
    }
    /**
     * Add item to comparendos value
     * @throws \InvalidArgumentException
     * @param \StructType\CursoComparendo $item
     * @return \StructType\DatosEntradaCursoCia
     */
    public function addToComparendos(\StructType\CursoComparendo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CursoComparendo) {
            throw new \InvalidArgumentException(sprintf('The comparendos property can only contain items of \StructType\CursoComparendo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->comparendos[] = $item;
        return $this;
    }
    /**
     * Get direccionAdquiriente value
     * @return string|null
     */
    public function getDireccionAdquiriente()
    {
        return $this->direccionAdquiriente;
    }
    /**
     * Set direccionAdquiriente value
     * @param string $direccionAdquiriente
     * @return \StructType\DatosEntradaCursoCia
     */
    public function setDireccionAdquiriente($direccionAdquiriente = null)
    {
        // validation for constraint: string
        if (!is_null($direccionAdquiriente) && !is_string($direccionAdquiriente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($direccionAdquiriente)), __LINE__);
        }
        $this->direccionAdquiriente = $direccionAdquiriente;
        return $this;
    }
    /**
     * Get fechaRealizacionCurso value
     * @return string|null
     */
    public function getFechaRealizacionCurso()
    {
        return $this->fechaRealizacionCurso;
    }
    /**
     * Set fechaRealizacionCurso value
     * @param string $fechaRealizacionCurso
     * @return \StructType\DatosEntradaCursoCia
     */
    public function setFechaRealizacionCurso($fechaRealizacionCurso = null)
    {
        // validation for constraint: string
        if (!is_null($fechaRealizacionCurso) && !is_string($fechaRealizacionCurso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fechaRealizacionCurso)), __LINE__);
        }
        $this->fechaRealizacionCurso = $fechaRealizacionCurso;
        return $this;
    }
    /**
     * Get fechaTransaccion value
     * @return string|null
     */
    public function getFechaTransaccion()
    {
        return $this->fechaTransaccion;
    }
    /**
     * Set fechaTransaccion value
     * @param string $fechaTransaccion
     * @return \StructType\DatosEntradaCursoCia
     */
    public function setFechaTransaccion($fechaTransaccion = null)
    {
        // validation for constraint: string
        if (!is_null($fechaTransaccion) && !is_string($fechaTransaccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fechaTransaccion)), __LINE__);
        }
        $this->fechaTransaccion = $fechaTransaccion;
        return $this;
    }
    /**
     * Get funcionarioRegistra value
     * @return string|null
     */
    public function getFuncionarioRegistra()
    {
        return $this->funcionarioRegistra;
    }
    /**
     * Set funcionarioRegistra value
     * @param string $funcionarioRegistra
     * @return \StructType\DatosEntradaCursoCia
     */
    public function setFuncionarioRegistra($funcionarioRegistra = null)
    {
        // validation for constraint: string
        if (!is_null($funcionarioRegistra) && !is_string($funcionarioRegistra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($funcionarioRegistra)), __LINE__);
        }
        $this->funcionarioRegistra = $funcionarioRegistra;
        return $this;
    }
    /**
     * Get horaFinCurso value
     * @return string|null
     */
    public function getHoraFinCurso()
    {
        return $this->horaFinCurso;
    }
    /**
     * Set horaFinCurso value
     * @param string $horaFinCurso
     * @return \StructType\DatosEntradaCursoCia
     */
    public function setHoraFinCurso($horaFinCurso = null)
    {
        // validation for constraint: string
        if (!is_null($horaFinCurso) && !is_string($horaFinCurso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($horaFinCurso)), __LINE__);
        }
        $this->horaFinCurso = $horaFinCurso;
        return $this;
    }
    /**
     * Get horaInicioCurso value
     * @return string|null
     */
    public function getHoraInicioCurso()
    {
        return $this->horaInicioCurso;
    }
    /**
     * Set horaInicioCurso value
     * @param string $horaInicioCurso
     * @return \StructType\DatosEntradaCursoCia
     */
    public function setHoraInicioCurso($horaInicioCurso = null)
    {
        // validation for constraint: string
        if (!is_null($horaInicioCurso) && !is_string($horaInicioCurso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($horaInicioCurso)), __LINE__);
        }
        $this->horaInicioCurso = $horaInicioCurso;
        return $this;
    }
    /**
     * Get horaTransaccion value
     * @return string|null
     */
    public function getHoraTransaccion()
    {
        return $this->horaTransaccion;
    }
    /**
     * Set horaTransaccion value
     * @param string $horaTransaccion
     * @return \StructType\DatosEntradaCursoCia
     */
    public function setHoraTransaccion($horaTransaccion = null)
    {
        // validation for constraint: string
        if (!is_null($horaTransaccion) && !is_string($horaTransaccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($horaTransaccion)), __LINE__);
        }
        $this->horaTransaccion = $horaTransaccion;
        return $this;
    }
    /**
     * Get identificacionInfractor value
     * @return string|null
     */
    public function getIdentificacionInfractor()
    {
        return $this->identificacionInfractor;
    }
    /**
     * Set identificacionInfractor value
     * @param string $identificacionInfractor
     * @return \StructType\DatosEntradaCursoCia
     */
    public function setIdentificacionInfractor($identificacionInfractor = null)
    {
        // validation for constraint: string
        if (!is_null($identificacionInfractor) && !is_string($identificacionInfractor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificacionInfractor)), __LINE__);
        }
        $this->identificacionInfractor = $identificacionInfractor;
        return $this;
    }
    /**
     * Get identificacionInstructor value
     * @return string|null
     */
    public function getIdentificacionInstructor()
    {
        return $this->identificacionInstructor;
    }
    /**
     * Set identificacionInstructor value
     * @param string $identificacionInstructor
     * @return \StructType\DatosEntradaCursoCia
     */
    public function setIdentificacionInstructor($identificacionInstructor = null)
    {
        // validation for constraint: string
        if (!is_null($identificacionInstructor) && !is_string($identificacionInstructor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificacionInstructor)), __LINE__);
        }
        $this->identificacionInstructor = $identificacionInstructor;
        return $this;
    }
    /**
     * Get numeroSecuencia value
     * @return string|null
     */
    public function getNumeroSecuencia()
    {
        return $this->numeroSecuencia;
    }
    /**
     * Set numeroSecuencia value
     * @param string $numeroSecuencia
     * @return \StructType\DatosEntradaCursoCia
     */
    public function setNumeroSecuencia($numeroSecuencia = null)
    {
        // validation for constraint: string
        if (!is_null($numeroSecuencia) && !is_string($numeroSecuencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numeroSecuencia)), __LINE__);
        }
        $this->numeroSecuencia = $numeroSecuencia;
        return $this;
    }
    /**
     * Get tipoIdentificacion value
     * @return string|null
     */
    public function getTipoIdentificacion()
    {
        return $this->tipoIdentificacion;
    }
    /**
     * Set tipoIdentificacion value
     * @param string $tipoIdentificacion
     * @return \StructType\DatosEntradaCursoCia
     */
    public function setTipoIdentificacion($tipoIdentificacion = null)
    {
        // validation for constraint: string
        if (!is_null($tipoIdentificacion) && !is_string($tipoIdentificacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoIdentificacion)), __LINE__);
        }
        $this->tipoIdentificacion = $tipoIdentificacion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DatosEntradaCursoCia
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
