<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pagoComparendo StructType
 * @subpackage Structs
 */
class PagoComparendo extends AbstractStructBase
{
    /**
     * The fechaComparendo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fechaComparendo;
    /**
     * The numeroComparendo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numeroComparendo;
    /**
     * The numeroResolucion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numeroResolucion;
    /**
     * The organismoTransito
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $organismoTransito;
    /**
     * The porcentajeDescuento
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $porcentajeDescuento;
    /**
     * The referenciaDescuento
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $referenciaDescuento;
    /**
     * The tipoComparendo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoComparendo;
    /**
     * The valorCia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $valorCia;
    /**
     * The valorInfraccion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $valorInfraccion;
    /**
     * Constructor method for pagoComparendo
     * @uses PagoComparendo::setFechaComparendo()
     * @uses PagoComparendo::setNumeroComparendo()
     * @uses PagoComparendo::setNumeroResolucion()
     * @uses PagoComparendo::setOrganismoTransito()
     * @uses PagoComparendo::setPorcentajeDescuento()
     * @uses PagoComparendo::setReferenciaDescuento()
     * @uses PagoComparendo::setTipoComparendo()
     * @uses PagoComparendo::setValorCia()
     * @uses PagoComparendo::setValorInfraccion()
     * @param string $fechaComparendo
     * @param string $numeroComparendo
     * @param string $numeroResolucion
     * @param string $organismoTransito
     * @param string $porcentajeDescuento
     * @param string $referenciaDescuento
     * @param string $tipoComparendo
     * @param string $valorCia
     * @param string $valorInfraccion
     */
    public function __construct($fechaComparendo = null, $numeroComparendo = null, $numeroResolucion = null, $organismoTransito = null, $porcentajeDescuento = null, $referenciaDescuento = null, $tipoComparendo = null, $valorCia = null, $valorInfraccion = null)
    {
        $this
            ->setFechaComparendo($fechaComparendo)
            ->setNumeroComparendo($numeroComparendo)
            ->setNumeroResolucion($numeroResolucion)
            ->setOrganismoTransito($organismoTransito)
            ->setPorcentajeDescuento($porcentajeDescuento)
            ->setReferenciaDescuento($referenciaDescuento)
            ->setTipoComparendo($tipoComparendo)
            ->setValorCia($valorCia)
            ->setValorInfraccion($valorInfraccion);
    }
    /**
     * Get fechaComparendo value
     * @return string|null
     */
    public function getFechaComparendo()
    {
        return $this->fechaComparendo;
    }
    /**
     * Set fechaComparendo value
     * @param string $fechaComparendo
     * @return \StructType\PagoComparendo
     */
    public function setFechaComparendo($fechaComparendo = null)
    {
        // validation for constraint: string
        if (!is_null($fechaComparendo) && !is_string($fechaComparendo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fechaComparendo)), __LINE__);
        }
        $this->fechaComparendo = $fechaComparendo;
        return $this;
    }
    /**
     * Get numeroComparendo value
     * @return string|null
     */
    public function getNumeroComparendo()
    {
        return $this->numeroComparendo;
    }
    /**
     * Set numeroComparendo value
     * @param string $numeroComparendo
     * @return \StructType\PagoComparendo
     */
    public function setNumeroComparendo($numeroComparendo = null)
    {
        // validation for constraint: string
        if (!is_null($numeroComparendo) && !is_string($numeroComparendo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numeroComparendo)), __LINE__);
        }
        $this->numeroComparendo = $numeroComparendo;
        return $this;
    }
    /**
     * Get numeroResolucion value
     * @return string|null
     */
    public function getNumeroResolucion()
    {
        return $this->numeroResolucion;
    }
    /**
     * Set numeroResolucion value
     * @param string $numeroResolucion
     * @return \StructType\PagoComparendo
     */
    public function setNumeroResolucion($numeroResolucion = null)
    {
        // validation for constraint: string
        if (!is_null($numeroResolucion) && !is_string($numeroResolucion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numeroResolucion)), __LINE__);
        }
        $this->numeroResolucion = $numeroResolucion;
        return $this;
    }
    /**
     * Get organismoTransito value
     * @return string|null
     */
    public function getOrganismoTransito()
    {
        return $this->organismoTransito;
    }
    /**
     * Set organismoTransito value
     * @param string $organismoTransito
     * @return \StructType\PagoComparendo
     */
    public function setOrganismoTransito($organismoTransito = null)
    {
        // validation for constraint: string
        if (!is_null($organismoTransito) && !is_string($organismoTransito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organismoTransito)), __LINE__);
        }
        $this->organismoTransito = $organismoTransito;
        return $this;
    }
    /**
     * Get porcentajeDescuento value
     * @return string|null
     */
    public function getPorcentajeDescuento()
    {
        return $this->porcentajeDescuento;
    }
    /**
     * Set porcentajeDescuento value
     * @param string $porcentajeDescuento
     * @return \StructType\PagoComparendo
     */
    public function setPorcentajeDescuento($porcentajeDescuento = null)
    {
        // validation for constraint: string
        if (!is_null($porcentajeDescuento) && !is_string($porcentajeDescuento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($porcentajeDescuento)), __LINE__);
        }
        $this->porcentajeDescuento = $porcentajeDescuento;
        return $this;
    }
    /**
     * Get referenciaDescuento value
     * @return string|null
     */
    public function getReferenciaDescuento()
    {
        return $this->referenciaDescuento;
    }
    /**
     * Set referenciaDescuento value
     * @param string $referenciaDescuento
     * @return \StructType\PagoComparendo
     */
    public function setReferenciaDescuento($referenciaDescuento = null)
    {
        // validation for constraint: string
        if (!is_null($referenciaDescuento) && !is_string($referenciaDescuento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenciaDescuento)), __LINE__);
        }
        $this->referenciaDescuento = $referenciaDescuento;
        return $this;
    }
    /**
     * Get tipoComparendo value
     * @return string|null
     */
    public function getTipoComparendo()
    {
        return $this->tipoComparendo;
    }
    /**
     * Set tipoComparendo value
     * @param string $tipoComparendo
     * @return \StructType\PagoComparendo
     */
    public function setTipoComparendo($tipoComparendo = null)
    {
        // validation for constraint: string
        if (!is_null($tipoComparendo) && !is_string($tipoComparendo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoComparendo)), __LINE__);
        }
        $this->tipoComparendo = $tipoComparendo;
        return $this;
    }
    /**
     * Get valorCia value
     * @return string|null
     */
    public function getValorCia()
    {
        return $this->valorCia;
    }
    /**
     * Set valorCia value
     * @param string $valorCia
     * @return \StructType\PagoComparendo
     */
    public function setValorCia($valorCia = null)
    {
        // validation for constraint: string
        if (!is_null($valorCia) && !is_string($valorCia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($valorCia)), __LINE__);
        }
        $this->valorCia = $valorCia;
        return $this;
    }
    /**
     * Get valorInfraccion value
     * @return string|null
     */
    public function getValorInfraccion()
    {
        return $this->valorInfraccion;
    }
    /**
     * Set valorInfraccion value
     * @param string $valorInfraccion
     * @return \StructType\PagoComparendo
     */
    public function setValorInfraccion($valorInfraccion = null)
    {
        // validation for constraint: string
        if (!is_null($valorInfraccion) && !is_string($valorInfraccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($valorInfraccion)), __LINE__);
        }
        $this->valorInfraccion = $valorInfraccion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PagoComparendo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
