<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for WSS ServiceType
 * @subpackage Services
 */
class WSS extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named WS_Simit_ComparendosDescuentos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WS_Simit_ComparendosDescuentos $parameters
     * @return \StructType\WS_Simit_ComparendosDescuentosResponse|bool
     */
    public function WS_Simit_ComparendosDescuentos(\StructType\WS_Simit_ComparendosDescuentos $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->WS_Simit_ComparendosDescuentos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named WS_Simit_CursoCia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WS_Simit_CursoCia $parameters
     * @return \StructType\WS_Simit_CursoCiaResponse|bool
     */
    public function WS_Simit_CursoCia(\StructType\WS_Simit_CursoCia $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->WS_Simit_CursoCia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named WS_Simit_PagoCursoCia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WS_Simit_PagoCursoCia $parameters
     * @return \StructType\WS_Simit_PagoCursoCiaResponse|bool
     */
    public function WS_Simit_PagoCursoCia(\StructType\WS_Simit_PagoCursoCia $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->WS_Simit_PagoCursoCia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named WS_Simit_PagoCia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WS_Simit_PagoCia $parameters
     * @return \StructType\WS_Simit_PagoCiaResponse|bool
     */
    public function WS_Simit_PagoCia(\StructType\WS_Simit_PagoCia $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->WS_Simit_PagoCia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\WS_Simit_ComparendosDescuentosResponse|\StructType\WS_Simit_CursoCiaResponse|\StructType\WS_Simit_PagoCiaResponse|\StructType\WS_Simit_PagoCursoCiaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
