<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www2.simit.org.co:8080/WSSimitCurso/WS_Simit_Curso?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www2.simit.org.co:8080/WSSimitCurso/WS_Simit_Curso?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for WSS ServiceType
 */
$wSS = new \ServiceType\WSS($options);
/**
 * Sample call for WS_Simit_PagoCia operation/method
 */
if ($wSS->WS_Simit_PagoCia(new \StructType\WS_Simit_PagoCia()) !== false) {
    print_r($wSS->getResult());
} else {
    print_r($wSS->getLastError());
}
/**
 * Sample call for WS_Simit_ComparendosDescuentos operation/method
 */
if ($wSS->WS_Simit_ComparendosDescuentos(new \StructType\WS_Simit_ComparendosDescuentos()) !== false) {
    print_r($wSS->getResult());
} else {
    print_r($wSS->getLastError());
}
/**
 * Sample call for WS_Simit_PagoCursoCia operation/method
 */
if ($wSS->WS_Simit_PagoCursoCia(new \StructType\WS_Simit_PagoCursoCia()) !== false) {
    print_r($wSS->getResult());
} else {
    print_r($wSS->getLastError());
}
/**
 * Sample call for WS_Simit_CursoCia operation/method
 */
if ($wSS->WS_Simit_CursoCia(new \StructType\WS_Simit_CursoCia()) !== false) {
    print_r($wSS->getResult());
} else {
    print_r($wSS->getLastError());
}
