<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for datosSalidaComparendosDescuento StructType
 * @subpackage Structs
 */
class DatosSalidaComparendosDescuento extends AbstractStructBase
{
    /**
     * The codigoRespuesta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigoRespuesta;
    /**
     * The comparendosDescuento
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ComparendoDescuento[]
     */
    public $comparendosDescuento;
    /**
     * The fechaTransaccion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fechaTransaccion;
    /**
     * The horaTransaccion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $horaTransaccion;
    /**
     * The identificacionInfractor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $identificacionInfractor;
    /**
     * The mensajeRespuesta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mensajeRespuesta;
    /**
     * The nombreInfractor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nombreInfractor;
    /**
     * The numAutorizacion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numAutorizacion;
    /**
     * The numeroResolucion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numeroResolucion;
    /**
     * The numeroSecuencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numeroSecuencia;
    /**
     * The tipoIdentificacion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoIdentificacion;
    /**
     * Constructor method for datosSalidaComparendosDescuento
     * @uses DatosSalidaComparendosDescuento::setCodigoRespuesta()
     * @uses DatosSalidaComparendosDescuento::setComparendosDescuento()
     * @uses DatosSalidaComparendosDescuento::setFechaTransaccion()
     * @uses DatosSalidaComparendosDescuento::setHoraTransaccion()
     * @uses DatosSalidaComparendosDescuento::setIdentificacionInfractor()
     * @uses DatosSalidaComparendosDescuento::setMensajeRespuesta()
     * @uses DatosSalidaComparendosDescuento::setNombreInfractor()
     * @uses DatosSalidaComparendosDescuento::setNumAutorizacion()
     * @uses DatosSalidaComparendosDescuento::setNumeroResolucion()
     * @uses DatosSalidaComparendosDescuento::setNumeroSecuencia()
     * @uses DatosSalidaComparendosDescuento::setTipoIdentificacion()
     * @param string $codigoRespuesta
     * @param \StructType\ComparendoDescuento[] $comparendosDescuento
     * @param string $fechaTransaccion
     * @param string $horaTransaccion
     * @param string $identificacionInfractor
     * @param string $mensajeRespuesta
     * @param string $nombreInfractor
     * @param string $numAutorizacion
     * @param string $numeroResolucion
     * @param string $numeroSecuencia
     * @param string $tipoIdentificacion
     */
    public function __construct($codigoRespuesta = null, array $comparendosDescuento = array(), $fechaTransaccion = null, $horaTransaccion = null, $identificacionInfractor = null, $mensajeRespuesta = null, $nombreInfractor = null, $numAutorizacion = null, $numeroResolucion = null, $numeroSecuencia = null, $tipoIdentificacion = null)
    {
        $this
            ->setCodigoRespuesta($codigoRespuesta)
            ->setComparendosDescuento($comparendosDescuento)
            ->setFechaTransaccion($fechaTransaccion)
            ->setHoraTransaccion($horaTransaccion)
            ->setIdentificacionInfractor($identificacionInfractor)
            ->setMensajeRespuesta($mensajeRespuesta)
            ->setNombreInfractor($nombreInfractor)
            ->setNumAutorizacion($numAutorizacion)
            ->setNumeroResolucion($numeroResolucion)
            ->setNumeroSecuencia($numeroSecuencia)
            ->setTipoIdentificacion($tipoIdentificacion);
    }
    /**
     * Get codigoRespuesta value
     * @return string|null
     */
    public function getCodigoRespuesta()
    {
        return $this->codigoRespuesta;
    }
    /**
     * Set codigoRespuesta value
     * @param string $codigoRespuesta
     * @return \StructType\DatosSalidaComparendosDescuento
     */
    public function setCodigoRespuesta($codigoRespuesta = null)
    {
        // validation for constraint: string
        if (!is_null($codigoRespuesta) && !is_string($codigoRespuesta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoRespuesta)), __LINE__);
        }
        $this->codigoRespuesta = $codigoRespuesta;
        return $this;
    }
    /**
     * Get comparendosDescuento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ComparendoDescuento[]|null
     */
    public function getComparendosDescuento()
    {
        return isset($this->comparendosDescuento) ? $this->comparendosDescuento : null;
    }
    /**
     * Set comparendosDescuento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ComparendoDescuento[] $comparendosDescuento
     * @return \StructType\DatosSalidaComparendosDescuento
     */
    public function setComparendosDescuento(array $comparendosDescuento = array())
    {
        foreach ($comparendosDescuento as $datosSalidaComparendosDescuentoComparendosDescuentoItem) {
            // validation for constraint: itemType
            if (!$datosSalidaComparendosDescuentoComparendosDescuentoItem instanceof \StructType\ComparendoDescuento) {
                throw new \InvalidArgumentException(sprintf('The comparendosDescuento property can only contain items of \StructType\ComparendoDescuento, "%s" given', is_object($datosSalidaComparendosDescuentoComparendosDescuentoItem) ? get_class($datosSalidaComparendosDescuentoComparendosDescuentoItem) : gettype($datosSalidaComparendosDescuentoComparendosDescuentoItem)), __LINE__);
            }
        }
        if (is_null($comparendosDescuento) || (is_array($comparendosDescuento) && empty($comparendosDescuento))) {
            unset($this->comparendosDescuento);
        } else {
            $this->comparendosDescuento = $comparendosDescuento;
        }
        return $this;
    }
    /**
     * Add item to comparendosDescuento value
     * @throws \InvalidArgumentException
     * @param \StructType\ComparendoDescuento $item
     * @return \StructType\DatosSalidaComparendosDescuento
     */
    public function addToComparendosDescuento(\StructType\ComparendoDescuento $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ComparendoDescuento) {
            throw new \InvalidArgumentException(sprintf('The comparendosDescuento property can only contain items of \StructType\ComparendoDescuento, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->comparendosDescuento[] = $item;
        return $this;
    }
    /**
     * Get fechaTransaccion value
     * @return string|null
     */
    public function getFechaTransaccion()
    {
        return $this->fechaTransaccion;
    }
    /**
     * Set fechaTransaccion value
     * @param string $fechaTransaccion
     * @return \StructType\DatosSalidaComparendosDescuento
     */
    public function setFechaTransaccion($fechaTransaccion = null)
    {
        // validation for constraint: string
        if (!is_null($fechaTransaccion) && !is_string($fechaTransaccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fechaTransaccion)), __LINE__);
        }
        $this->fechaTransaccion = $fechaTransaccion;
        return $this;
    }
    /**
     * Get horaTransaccion value
     * @return string|null
     */
    public function getHoraTransaccion()
    {
        return $this->horaTransaccion;
    }
    /**
     * Set horaTransaccion value
     * @param string $horaTransaccion
     * @return \StructType\DatosSalidaComparendosDescuento
     */
    public function setHoraTransaccion($horaTransaccion = null)
    {
        // validation for constraint: string
        if (!is_null($horaTransaccion) && !is_string($horaTransaccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($horaTransaccion)), __LINE__);
        }
        $this->horaTransaccion = $horaTransaccion;
        return $this;
    }
    /**
     * Get identificacionInfractor value
     * @return string|null
     */
    public function getIdentificacionInfractor()
    {
        return $this->identificacionInfractor;
    }
    /**
     * Set identificacionInfractor value
     * @param string $identificacionInfractor
     * @return \StructType\DatosSalidaComparendosDescuento
     */
    public function setIdentificacionInfractor($identificacionInfractor = null)
    {
        // validation for constraint: string
        if (!is_null($identificacionInfractor) && !is_string($identificacionInfractor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificacionInfractor)), __LINE__);
        }
        $this->identificacionInfractor = $identificacionInfractor;
        return $this;
    }
    /**
     * Get mensajeRespuesta value
     * @return string|null
     */
    public function getMensajeRespuesta()
    {
        return $this->mensajeRespuesta;
    }
    /**
     * Set mensajeRespuesta value
     * @param string $mensajeRespuesta
     * @return \StructType\DatosSalidaComparendosDescuento
     */
    public function setMensajeRespuesta($mensajeRespuesta = null)
    {
        // validation for constraint: string
        if (!is_null($mensajeRespuesta) && !is_string($mensajeRespuesta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mensajeRespuesta)), __LINE__);
        }
        $this->mensajeRespuesta = $mensajeRespuesta;
        return $this;
    }
    /**
     * Get nombreInfractor value
     * @return string|null
     */
    public function getNombreInfractor()
    {
        return $this->nombreInfractor;
    }
    /**
     * Set nombreInfractor value
     * @param string $nombreInfractor
     * @return \StructType\DatosSalidaComparendosDescuento
     */
    public function setNombreInfractor($nombreInfractor = null)
    {
        // validation for constraint: string
        if (!is_null($nombreInfractor) && !is_string($nombreInfractor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nombreInfractor)), __LINE__);
        }
        $this->nombreInfractor = $nombreInfractor;
        return $this;
    }
    /**
     * Get numAutorizacion value
     * @return string|null
     */
    public function getNumAutorizacion()
    {
        return $this->numAutorizacion;
    }
    /**
     * Set numAutorizacion value
     * @param string $numAutorizacion
     * @return \StructType\DatosSalidaComparendosDescuento
     */
    public function setNumAutorizacion($numAutorizacion = null)
    {
        // validation for constraint: string
        if (!is_null($numAutorizacion) && !is_string($numAutorizacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numAutorizacion)), __LINE__);
        }
        $this->numAutorizacion = $numAutorizacion;
        return $this;
    }
    /**
     * Get numeroResolucion value
     * @return string|null
     */
    public function getNumeroResolucion()
    {
        return $this->numeroResolucion;
    }
    /**
     * Set numeroResolucion value
     * @param string $numeroResolucion
     * @return \StructType\DatosSalidaComparendosDescuento
     */
    public function setNumeroResolucion($numeroResolucion = null)
    {
        // validation for constraint: string
        if (!is_null($numeroResolucion) && !is_string($numeroResolucion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numeroResolucion)), __LINE__);
        }
        $this->numeroResolucion = $numeroResolucion;
        return $this;
    }
    /**
     * Get numeroSecuencia value
     * @return string|null
     */
    public function getNumeroSecuencia()
    {
        return $this->numeroSecuencia;
    }
    /**
     * Set numeroSecuencia value
     * @param string $numeroSecuencia
     * @return \StructType\DatosSalidaComparendosDescuento
     */
    public function setNumeroSecuencia($numeroSecuencia = null)
    {
        // validation for constraint: string
        if (!is_null($numeroSecuencia) && !is_string($numeroSecuencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numeroSecuencia)), __LINE__);
        }
        $this->numeroSecuencia = $numeroSecuencia;
        return $this;
    }
    /**
     * Get tipoIdentificacion value
     * @return string|null
     */
    public function getTipoIdentificacion()
    {
        return $this->tipoIdentificacion;
    }
    /**
     * Set tipoIdentificacion value
     * @param string $tipoIdentificacion
     * @return \StructType\DatosSalidaComparendosDescuento
     */
    public function setTipoIdentificacion($tipoIdentificacion = null)
    {
        // validation for constraint: string
        if (!is_null($tipoIdentificacion) && !is_string($tipoIdentificacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoIdentificacion)), __LINE__);
        }
        $this->tipoIdentificacion = $tipoIdentificacion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DatosSalidaComparendosDescuento
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
