<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InquiryRequestType StructType
 * @subpackage Structs
 */
class InquiryRequestType extends AbstractStructBase
{
    /**
     * The UnitRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UnitRef
     */
    public $UnitRef;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Contact
     */
    public $Contact;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FormattedTextTextType
     */
    public $Message;
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Source
     */
    public $Source;
    /**
     * The StayDateRange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DateTimeSpanType
     */
    public $StayDateRange;
    /**
     * The GuestCounts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GuestCountType
     */
    public $GuestCounts;
    /**
     * The InquiryType
     * @var string
     */
    public $InquiryType;
    /**
     * The InquiryDate
     * @var string
     */
    public $InquiryDate;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * Constructor method for InquiryRequestType
     * @uses InquiryRequestType::setUnitRef()
     * @uses InquiryRequestType::setContact()
     * @uses InquiryRequestType::setMessage()
     * @uses InquiryRequestType::setSource()
     * @uses InquiryRequestType::setStayDateRange()
     * @uses InquiryRequestType::setGuestCounts()
     * @uses InquiryRequestType::setInquiryType()
     * @uses InquiryRequestType::setInquiryDate()
     * @uses InquiryRequestType::setTransactionIdentifier()
     * @param \StructType\UnitRef $unitRef
     * @param \StructType\Contact $contact
     * @param \StructType\FormattedTextTextType $message
     * @param \StructType\Source $source
     * @param \StructType\DateTimeSpanType $stayDateRange
     * @param \StructType\GuestCountType $guestCounts
     * @param string $inquiryType
     * @param string $inquiryDate
     * @param string $transactionIdentifier
     */
    public function __construct(\StructType\UnitRef $unitRef = null, \StructType\Contact $contact = null, \StructType\FormattedTextTextType $message = null, \StructType\Source $source = null, \StructType\DateTimeSpanType $stayDateRange = null, \StructType\GuestCountType $guestCounts = null, $inquiryType = null, $inquiryDate = null, $transactionIdentifier = null)
    {
        $this
            ->setUnitRef($unitRef)
            ->setContact($contact)
            ->setMessage($message)
            ->setSource($source)
            ->setStayDateRange($stayDateRange)
            ->setGuestCounts($guestCounts)
            ->setInquiryType($inquiryType)
            ->setInquiryDate($inquiryDate)
            ->setTransactionIdentifier($transactionIdentifier);
    }
    /**
     * Get UnitRef value
     * @return \StructType\UnitRef|null
     */
    public function getUnitRef()
    {
        return $this->UnitRef;
    }
    /**
     * Set UnitRef value
     * @param \StructType\UnitRef $unitRef
     * @return \StructType\InquiryRequestType
     */
    public function setUnitRef(\StructType\UnitRef $unitRef = null)
    {
        $this->UnitRef = $unitRef;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\Contact|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\Contact $contact
     * @return \StructType\InquiryRequestType
     */
    public function setContact(\StructType\Contact $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Message value
     * @return \StructType\FormattedTextTextType|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param \StructType\FormattedTextTextType $message
     * @return \StructType\InquiryRequestType
     */
    public function setMessage(\StructType\FormattedTextTextType $message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Source value
     * @return \StructType\Source|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param \StructType\Source $source
     * @return \StructType\InquiryRequestType
     */
    public function setSource(\StructType\Source $source = null)
    {
        $this->Source = $source;
        return $this;
    }
    /**
     * Get StayDateRange value
     * @return \StructType\DateTimeSpanType|null
     */
    public function getStayDateRange()
    {
        return $this->StayDateRange;
    }
    /**
     * Set StayDateRange value
     * @param \StructType\DateTimeSpanType $stayDateRange
     * @return \StructType\InquiryRequestType
     */
    public function setStayDateRange(\StructType\DateTimeSpanType $stayDateRange = null)
    {
        $this->StayDateRange = $stayDateRange;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \StructType\GuestCountType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \StructType\GuestCountType $guestCounts
     * @return \StructType\InquiryRequestType
     */
    public function setGuestCounts(\StructType\GuestCountType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get InquiryType value
     * @return string|null
     */
    public function getInquiryType()
    {
        return $this->InquiryType;
    }
    /**
     * Set InquiryType value
     * @param string $inquiryType
     * @return \StructType\InquiryRequestType
     */
    public function setInquiryType($inquiryType = null)
    {
        // validation for constraint: string
        if (!is_null($inquiryType) && !is_string($inquiryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inquiryType, true), gettype($inquiryType)), __LINE__);
        }
        $this->InquiryType = $inquiryType;
        return $this;
    }
    /**
     * Get InquiryDate value
     * @return string|null
     */
    public function getInquiryDate()
    {
        return $this->InquiryDate;
    }
    /**
     * Set InquiryDate value
     * @param string $inquiryDate
     * @return \StructType\InquiryRequestType
     */
    public function setInquiryDate($inquiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($inquiryDate) && !is_string($inquiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inquiryDate, true), gettype($inquiryDate)), __LINE__);
        }
        $this->InquiryDate = $inquiryDate;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\InquiryRequestType
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionIdentifier, true), gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InquiryRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
