<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatingPrefType StructType
 * @subpackage Structs
 */
class SeatingPrefType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The SeatDirection
     * @var string
     */
    public $SeatDirection;
    /**
     * The SeatLocation
     * @var string
     */
    public $SeatLocation;
    /**
     * The SeatPosition
     * @var string
     */
    public $SeatPosition;
    /**
     * The SeatRow
     * @var string
     */
    public $SeatRow;
    /**
     * Constructor method for SeatingPrefType
     * @uses SeatingPrefType::set_()
     * @uses SeatingPrefType::setPreferLevel()
     * @uses SeatingPrefType::setSeatDirection()
     * @uses SeatingPrefType::setSeatLocation()
     * @uses SeatingPrefType::setSeatPosition()
     * @uses SeatingPrefType::setSeatRow()
     * @param string $_
     * @param string $preferLevel
     * @param string $seatDirection
     * @param string $seatLocation
     * @param string $seatPosition
     * @param string $seatRow
     */
    public function __construct($_ = null, $preferLevel = 'Preferred', $seatDirection = null, $seatLocation = null, $seatPosition = null, $seatRow = null)
    {
        $this
            ->set_($_)
            ->setPreferLevel($preferLevel)
            ->setSeatDirection($seatDirection)
            ->setSeatLocation($seatLocation)
            ->setSeatPosition($seatPosition)
            ->setSeatRow($seatRow);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\SeatingPrefType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\SeatingPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get SeatDirection value
     * @return string|null
     */
    public function getSeatDirection()
    {
        return $this->SeatDirection;
    }
    /**
     * Set SeatDirection value
     * @param string $seatDirection
     * @return \StructType\SeatingPrefType
     */
    public function setSeatDirection($seatDirection = null)
    {
        // validation for constraint: string
        if (!is_null($seatDirection) && !is_string($seatDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatDirection, true), gettype($seatDirection)), __LINE__);
        }
        $this->SeatDirection = $seatDirection;
        return $this;
    }
    /**
     * Get SeatLocation value
     * @return string|null
     */
    public function getSeatLocation()
    {
        return $this->SeatLocation;
    }
    /**
     * Set SeatLocation value
     * @param string $seatLocation
     * @return \StructType\SeatingPrefType
     */
    public function setSeatLocation($seatLocation = null)
    {
        // validation for constraint: string
        if (!is_null($seatLocation) && !is_string($seatLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatLocation, true), gettype($seatLocation)), __LINE__);
        }
        $this->SeatLocation = $seatLocation;
        return $this;
    }
    /**
     * Get SeatPosition value
     * @return string|null
     */
    public function getSeatPosition()
    {
        return $this->SeatPosition;
    }
    /**
     * Set SeatPosition value
     * @param string $seatPosition
     * @return \StructType\SeatingPrefType
     */
    public function setSeatPosition($seatPosition = null)
    {
        // validation for constraint: string
        if (!is_null($seatPosition) && !is_string($seatPosition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatPosition, true), gettype($seatPosition)), __LINE__);
        }
        $this->SeatPosition = $seatPosition;
        return $this;
    }
    /**
     * Get SeatRow value
     * @return string|null
     */
    public function getSeatRow()
    {
        return $this->SeatRow;
    }
    /**
     * Set SeatRow value
     * @param string $seatRow
     * @return \StructType\SeatingPrefType
     */
    public function setSeatRow($seatRow = null)
    {
        // validation for constraint: string
        if (!is_null($seatRow) && !is_string($seatRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatRow, true), gettype($seatRow)), __LINE__);
        }
        $this->SeatRow = $seatRow;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeatingPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
