<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyInfo StructType
 * @subpackage Structs
 */
class PolicyInfo extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ParagraphType
     */
    public $Description;
    /**
     * The CheckInTime
     * @var string
     */
    public $CheckInTime;
    /**
     * The CheckOutTime
     * @var string
     */
    public $CheckOutTime;
    /**
     * The SmokingAllowed
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The TotalGuestCount
     * @var int
     */
    public $TotalGuestCount;
    /**
     * Constructor method for PolicyInfo
     * @uses PolicyInfo::setDescription()
     * @uses PolicyInfo::setCheckInTime()
     * @uses PolicyInfo::setCheckOutTime()
     * @uses PolicyInfo::setSmokingAllowed()
     * @uses PolicyInfo::setTotalGuestCount()
     * @param \StructType\ParagraphType $description
     * @param string $checkInTime
     * @param string $checkOutTime
     * @param bool $smokingAllowed
     * @param int $totalGuestCount
     */
    public function __construct(\StructType\ParagraphType $description = null, $checkInTime = null, $checkOutTime = null, $smokingAllowed = false, $totalGuestCount = null)
    {
        $this
            ->setDescription($description)
            ->setCheckInTime($checkInTime)
            ->setCheckOutTime($checkOutTime)
            ->setSmokingAllowed($smokingAllowed)
            ->setTotalGuestCount($totalGuestCount);
    }
    /**
     * Get Description value
     * @return \StructType\ParagraphType|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\ParagraphType $description
     * @return \StructType\PolicyInfo
     */
    public function setDescription(\StructType\ParagraphType $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CheckInTime value
     * @return string|null
     */
    public function getCheckInTime()
    {
        return $this->CheckInTime;
    }
    /**
     * Set CheckInTime value
     * @param string $checkInTime
     * @return \StructType\PolicyInfo
     */
    public function setCheckInTime($checkInTime = null)
    {
        // validation for constraint: string
        if (!is_null($checkInTime) && !is_string($checkInTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkInTime, true), gettype($checkInTime)), __LINE__);
        }
        $this->CheckInTime = $checkInTime;
        return $this;
    }
    /**
     * Get CheckOutTime value
     * @return string|null
     */
    public function getCheckOutTime()
    {
        return $this->CheckOutTime;
    }
    /**
     * Set CheckOutTime value
     * @param string $checkOutTime
     * @return \StructType\PolicyInfo
     */
    public function setCheckOutTime($checkOutTime = null)
    {
        // validation for constraint: string
        if (!is_null($checkOutTime) && !is_string($checkOutTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkOutTime, true), gettype($checkOutTime)), __LINE__);
        }
        $this->CheckOutTime = $checkOutTime;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \StructType\PolicyInfo
     */
    public function setSmokingAllowed($smokingAllowed = false)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($smokingAllowed, true), gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get TotalGuestCount value
     * @return int|null
     */
    public function getTotalGuestCount()
    {
        return $this->TotalGuestCount;
    }
    /**
     * Set TotalGuestCount value
     * @param int $totalGuestCount
     * @return \StructType\PolicyInfo
     */
    public function setTotalGuestCount($totalGuestCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalGuestCount) && !(is_int($totalGuestCount) || ctype_digit($totalGuestCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalGuestCount, true), gettype($totalGuestCount)), __LINE__);
        }
        $this->TotalGuestCount = $totalGuestCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PolicyInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
