<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NamePrefType StructType
 * @subpackage Structs
 */
class NamePrefType extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The PersonName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PersonNameType
     */
    public $PersonName;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for NamePrefType
     * @uses NamePrefType::setUniqueID()
     * @uses NamePrefType::setPersonName()
     * @uses NamePrefType::setPreferLevel()
     * @param \StructType\UniqueID_Type $uniqueID
     * @param \StructType\PersonNameType $personName
     * @param string $preferLevel
     */
    public function __construct(\StructType\UniqueID_Type $uniqueID = null, \StructType\PersonNameType $personName = null, $preferLevel = 'Preferred')
    {
        $this
            ->setUniqueID($uniqueID)
            ->setPersonName($personName)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \StructType\UniqueID_Type $uniqueID
     * @return \StructType\NamePrefType
     */
    public function setUniqueID(\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \StructType\PersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \StructType\PersonNameType $personName
     * @return \StructType\NamePrefType
     */
    public function setPersonName(\StructType\PersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\NamePrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NamePrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
