<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMembershipTypeMembership ArrayType
 * @subpackage Arrays
 */
class ArrayOfMembershipTypeMembership extends AbstractStructArrayBase
{
    /**
     * The Membership
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Membership[]
     */
    public $Membership;
    /**
     * Constructor method for ArrayOfMembershipTypeMembership
     * @uses ArrayOfMembershipTypeMembership::setMembership()
     * @param \StructType\Membership[] $membership
     */
    public function __construct(array $membership = array())
    {
        $this
            ->setMembership($membership);
    }
    /**
     * Get Membership value
     * @return \StructType\Membership[]|null
     */
    public function getMembership()
    {
        return $this->Membership;
    }
    /**
     * This method is responsible for validating the values passed to the setMembership method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMembership method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMembershipForArrayConstraintsFromSetMembership(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMembershipTypeMembershipMembershipItem) {
            // validation for constraint: itemType
            if (!$arrayOfMembershipTypeMembershipMembershipItem instanceof \StructType\Membership) {
                $invalidValues[] = is_object($arrayOfMembershipTypeMembershipMembershipItem) ? get_class($arrayOfMembershipTypeMembershipMembershipItem) : sprintf('%s(%s)', gettype($arrayOfMembershipTypeMembershipMembershipItem), var_export($arrayOfMembershipTypeMembershipMembershipItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Membership property can only contain items of type \StructType\Membership, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Membership value
     * @throws \InvalidArgumentException
     * @param \StructType\Membership[] $membership
     * @return \ArrayType\ArrayOfMembershipTypeMembership
     */
    public function setMembership(array $membership = array())
    {
        // validation for constraint: array
        if ('' !== ($membershipArrayErrorMessage = self::validateMembershipForArrayConstraintsFromSetMembership($membership))) {
            throw new \InvalidArgumentException($membershipArrayErrorMessage, __LINE__);
        }
        $this->Membership = $membership;
        return $this;
    }
    /**
     * Add item to Membership value
     * @throws \InvalidArgumentException
     * @param \StructType\Membership $item
     * @return \ArrayType\ArrayOfMembershipTypeMembership
     */
    public function addToMembership(\StructType\Membership $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Membership) {
            throw new \InvalidArgumentException(sprintf('The Membership property can only contain items of type \StructType\Membership, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Membership[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Membership|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Membership|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Membership|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Membership|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Membership|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Membership
     */
    public function getAttributeName()
    {
        return 'Membership';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMembershipTypeMembership
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
