<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitStayType StructType
 * @subpackage Structs
 */
class UnitStayType extends AbstractStructBase
{
    /**
     * The UnitRates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfUnitStayTypeUnitRate
     */
    public $UnitRates;
    /**
     * The GuestCounts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GuestCountType
     */
    public $GuestCounts;
    /**
     * The TimeSpan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DateTimeSpanType
     */
    public $TimeSpan;
    /**
     * The DepositPayments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment
     */
    public $DepositPayments;
    /**
     * The CancelPenalties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CancelPenaltiesType
     */
    public $CancelPenalties;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TotalType
     */
    public $Total;
    /**
     * The BasicUnitInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BasicUnitInfoType
     */
    public $BasicUnitInfo;
    /**
     * The RentalAgreement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfParagraphType
     */
    public $RentalAgreement;
    /**
     * The Pets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PetsPoliciesType
     */
    public $Pets;
    /**
     * The AvailabilityStatus
     * @var string
     */
    public $AvailabilityStatus;
    /**
     * Constructor method for UnitStayType
     * @uses UnitStayType::setUnitRates()
     * @uses UnitStayType::setGuestCounts()
     * @uses UnitStayType::setTimeSpan()
     * @uses UnitStayType::setDepositPayments()
     * @uses UnitStayType::setCancelPenalties()
     * @uses UnitStayType::setTotal()
     * @uses UnitStayType::setBasicUnitInfo()
     * @uses UnitStayType::setRentalAgreement()
     * @uses UnitStayType::setPets()
     * @uses UnitStayType::setAvailabilityStatus()
     * @param \ArrayType\ArrayOfUnitStayTypeUnitRate $unitRates
     * @param \StructType\GuestCountType $guestCounts
     * @param \StructType\DateTimeSpanType $timeSpan
     * @param \ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments
     * @param \StructType\CancelPenaltiesType $cancelPenalties
     * @param \StructType\TotalType $total
     * @param \StructType\BasicUnitInfoType $basicUnitInfo
     * @param \ArrayType\ArrayOfParagraphType $rentalAgreement
     * @param \StructType\PetsPoliciesType $pets
     * @param string $availabilityStatus
     */
    public function __construct(\ArrayType\ArrayOfUnitStayTypeUnitRate $unitRates = null, \StructType\GuestCountType $guestCounts = null, \StructType\DateTimeSpanType $timeSpan = null, \ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments = null, \StructType\CancelPenaltiesType $cancelPenalties = null, \StructType\TotalType $total = null, \StructType\BasicUnitInfoType $basicUnitInfo = null, \ArrayType\ArrayOfParagraphType $rentalAgreement = null, \StructType\PetsPoliciesType $pets = null, $availabilityStatus = null)
    {
        $this
            ->setUnitRates($unitRates)
            ->setGuestCounts($guestCounts)
            ->setTimeSpan($timeSpan)
            ->setDepositPayments($depositPayments)
            ->setCancelPenalties($cancelPenalties)
            ->setTotal($total)
            ->setBasicUnitInfo($basicUnitInfo)
            ->setRentalAgreement($rentalAgreement)
            ->setPets($pets)
            ->setAvailabilityStatus($availabilityStatus);
    }
    /**
     * Get UnitRates value
     * @return \ArrayType\ArrayOfUnitStayTypeUnitRate|null
     */
    public function getUnitRates()
    {
        return $this->UnitRates;
    }
    /**
     * Set UnitRates value
     * @param \ArrayType\ArrayOfUnitStayTypeUnitRate $unitRates
     * @return \StructType\UnitStayType
     */
    public function setUnitRates(\ArrayType\ArrayOfUnitStayTypeUnitRate $unitRates = null)
    {
        $this->UnitRates = $unitRates;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \StructType\GuestCountType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \StructType\GuestCountType $guestCounts
     * @return \StructType\UnitStayType
     */
    public function setGuestCounts(\StructType\GuestCountType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get TimeSpan value
     * @return \StructType\DateTimeSpanType|null
     */
    public function getTimeSpan()
    {
        return $this->TimeSpan;
    }
    /**
     * Set TimeSpan value
     * @param \StructType\DateTimeSpanType $timeSpan
     * @return \StructType\UnitStayType
     */
    public function setTimeSpan(\StructType\DateTimeSpanType $timeSpan = null)
    {
        $this->TimeSpan = $timeSpan;
        return $this;
    }
    /**
     * Get DepositPayments value
     * @return \ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment|null
     */
    public function getDepositPayments()
    {
        return $this->DepositPayments;
    }
    /**
     * Set DepositPayments value
     * @param \ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments
     * @return \StructType\UnitStayType
     */
    public function setDepositPayments(\ArrayType\ArrayOfRequiredPaymentsTypeGuaranteePayment $depositPayments = null)
    {
        $this->DepositPayments = $depositPayments;
        return $this;
    }
    /**
     * Get CancelPenalties value
     * @return \StructType\CancelPenaltiesType|null
     */
    public function getCancelPenalties()
    {
        return $this->CancelPenalties;
    }
    /**
     * Set CancelPenalties value
     * @param \StructType\CancelPenaltiesType $cancelPenalties
     * @return \StructType\UnitStayType
     */
    public function setCancelPenalties(\StructType\CancelPenaltiesType $cancelPenalties = null)
    {
        $this->CancelPenalties = $cancelPenalties;
        return $this;
    }
    /**
     * Get Total value
     * @return \StructType\TotalType|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \StructType\TotalType $total
     * @return \StructType\UnitStayType
     */
    public function setTotal(\StructType\TotalType $total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get BasicUnitInfo value
     * @return \StructType\BasicUnitInfoType|null
     */
    public function getBasicUnitInfo()
    {
        return $this->BasicUnitInfo;
    }
    /**
     * Set BasicUnitInfo value
     * @param \StructType\BasicUnitInfoType $basicUnitInfo
     * @return \StructType\UnitStayType
     */
    public function setBasicUnitInfo(\StructType\BasicUnitInfoType $basicUnitInfo = null)
    {
        $this->BasicUnitInfo = $basicUnitInfo;
        return $this;
    }
    /**
     * Get RentalAgreement value
     * @return \ArrayType\ArrayOfParagraphType|null
     */
    public function getRentalAgreement()
    {
        return $this->RentalAgreement;
    }
    /**
     * Set RentalAgreement value
     * @param \ArrayType\ArrayOfParagraphType $rentalAgreement
     * @return \StructType\UnitStayType
     */
    public function setRentalAgreement(\ArrayType\ArrayOfParagraphType $rentalAgreement = null)
    {
        $this->RentalAgreement = $rentalAgreement;
        return $this;
    }
    /**
     * Get Pets value
     * @return \StructType\PetsPoliciesType|null
     */
    public function getPets()
    {
        return $this->Pets;
    }
    /**
     * Set Pets value
     * @param \StructType\PetsPoliciesType $pets
     * @return \StructType\UnitStayType
     */
    public function setPets(\StructType\PetsPoliciesType $pets = null)
    {
        $this->Pets = $pets;
        return $this;
    }
    /**
     * Get AvailabilityStatus value
     * @return string|null
     */
    public function getAvailabilityStatus()
    {
        return $this->AvailabilityStatus;
    }
    /**
     * Set AvailabilityStatus value
     * @uses \EnumType\RateIndicatorType::valueIsValid()
     * @uses \EnumType\RateIndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availabilityStatus
     * @return \StructType\UnitStayType
     */
    public function setAvailabilityStatus($availabilityStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RateIndicatorType::valueIsValid($availabilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RateIndicatorType', is_array($availabilityStatus) ? implode(', ', $availabilityStatus) : var_export($availabilityStatus, true), implode(', ', \EnumType\RateIndicatorType::getValidValues())), __LINE__);
        }
        $this->AvailabilityStatus = $availabilityStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnitStayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
