<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommissionPoliciesType StructType
 * @subpackage Structs
 */
class CommissionPoliciesType extends AbstractStructBase
{
    /**
     * The CommissionPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CommissionPolicyType[]
     */
    public $CommissionPolicy;
    /**
     * The MinCommissionPercent
     * @var float
     */
    public $MinCommissionPercent;
    /**
     * The MaxCommissionPercent
     * @var float
     */
    public $MaxCommissionPercent;
    /**
     * Constructor method for CommissionPoliciesType
     * @uses CommissionPoliciesType::setCommissionPolicy()
     * @uses CommissionPoliciesType::setMinCommissionPercent()
     * @uses CommissionPoliciesType::setMaxCommissionPercent()
     * @param \StructType\CommissionPolicyType[] $commissionPolicy
     * @param float $minCommissionPercent
     * @param float $maxCommissionPercent
     */
    public function __construct(array $commissionPolicy = array(), $minCommissionPercent = null, $maxCommissionPercent = null)
    {
        $this
            ->setCommissionPolicy($commissionPolicy)
            ->setMinCommissionPercent($minCommissionPercent)
            ->setMaxCommissionPercent($maxCommissionPercent);
    }
    /**
     * Get CommissionPolicy value
     * @return \StructType\CommissionPolicyType[]|null
     */
    public function getCommissionPolicy()
    {
        return $this->CommissionPolicy;
    }
    /**
     * This method is responsible for validating the values passed to the setCommissionPolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommissionPolicy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommissionPolicyForArrayConstraintsFromSetCommissionPolicy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commissionPoliciesTypeCommissionPolicyItem) {
            // validation for constraint: itemType
            if (!$commissionPoliciesTypeCommissionPolicyItem instanceof \StructType\CommissionPolicyType) {
                $invalidValues[] = is_object($commissionPoliciesTypeCommissionPolicyItem) ? get_class($commissionPoliciesTypeCommissionPolicyItem) : sprintf('%s(%s)', gettype($commissionPoliciesTypeCommissionPolicyItem), var_export($commissionPoliciesTypeCommissionPolicyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CommissionPolicy property can only contain items of type \StructType\CommissionPolicyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CommissionPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionPolicyType[] $commissionPolicy
     * @return \StructType\CommissionPoliciesType
     */
    public function setCommissionPolicy(array $commissionPolicy = array())
    {
        // validation for constraint: array
        if ('' !== ($commissionPolicyArrayErrorMessage = self::validateCommissionPolicyForArrayConstraintsFromSetCommissionPolicy($commissionPolicy))) {
            throw new \InvalidArgumentException($commissionPolicyArrayErrorMessage, __LINE__);
        }
        $this->CommissionPolicy = $commissionPolicy;
        return $this;
    }
    /**
     * Add item to CommissionPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionPolicyType $item
     * @return \StructType\CommissionPoliciesType
     */
    public function addToCommissionPolicy(\StructType\CommissionPolicyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommissionPolicyType) {
            throw new \InvalidArgumentException(sprintf('The CommissionPolicy property can only contain items of type \StructType\CommissionPolicyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CommissionPolicy[] = $item;
        return $this;
    }
    /**
     * Get MinCommissionPercent value
     * @return float|null
     */
    public function getMinCommissionPercent()
    {
        return $this->MinCommissionPercent;
    }
    /**
     * Set MinCommissionPercent value
     * @param float $minCommissionPercent
     * @return \StructType\CommissionPoliciesType
     */
    public function setMinCommissionPercent($minCommissionPercent = null)
    {
        // validation for constraint: float
        if (!is_null($minCommissionPercent) && !(is_float($minCommissionPercent) || is_numeric($minCommissionPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minCommissionPercent, true), gettype($minCommissionPercent)), __LINE__);
        }
        $this->MinCommissionPercent = $minCommissionPercent;
        return $this;
    }
    /**
     * Get MaxCommissionPercent value
     * @return float|null
     */
    public function getMaxCommissionPercent()
    {
        return $this->MaxCommissionPercent;
    }
    /**
     * Set MaxCommissionPercent value
     * @param float $maxCommissionPercent
     * @return \StructType\CommissionPoliciesType
     */
    public function setMaxCommissionPercent($maxCommissionPercent = null)
    {
        // validation for constraint: float
        if (!is_null($maxCommissionPercent) && !(is_float($maxCommissionPercent) || is_numeric($maxCommissionPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxCommissionPercent, true), gettype($maxCommissionPercent)), __LINE__);
        }
        $this->MaxCommissionPercent = $maxCommissionPercent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CommissionPoliciesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
