<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalendarAvailType StructType
 * @subpackage Structs
 */
class CalendarAvailType extends AbstractStructBase
{
    /**
     * The CalendarDateRange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DateTimeSpanType
     */
    public $CalendarDateRange;
    /**
     * The PropertyManagerCode
     * @var string
     */
    public $PropertyManagerCode;
    /**
     * The UnitCode
     * @var string
     */
    public $UnitCode;
    /**
     * The UnitName
     * @var string
     */
    public $UnitName;
    /**
     * The InfoSource
     * @var string
     */
    public $InfoSource;
    /**
     * The InternalUnitCode
     * @var string
     */
    public $InternalUnitCode;
    /**
     * The UnitHeadline
     * @var string
     */
    public $UnitHeadline;
    /**
     * The StateCodeList
     * @var string[]
     */
    public $StateCodeList;
    /**
     * The CountryCodeList
     * @var string[]
     */
    public $CountryCodeList;
    /**
     * The UpdatedAfter
     * @var string
     */
    public $UpdatedAfter;
    /**
     * Constructor method for CalendarAvailType
     * @uses CalendarAvailType::setCalendarDateRange()
     * @uses CalendarAvailType::setPropertyManagerCode()
     * @uses CalendarAvailType::setUnitCode()
     * @uses CalendarAvailType::setUnitName()
     * @uses CalendarAvailType::setInfoSource()
     * @uses CalendarAvailType::setInternalUnitCode()
     * @uses CalendarAvailType::setUnitHeadline()
     * @uses CalendarAvailType::setStateCodeList()
     * @uses CalendarAvailType::setCountryCodeList()
     * @uses CalendarAvailType::setUpdatedAfter()
     * @param \StructType\DateTimeSpanType $calendarDateRange
     * @param string $propertyManagerCode
     * @param string $unitCode
     * @param string $unitName
     * @param string $infoSource
     * @param string $internalUnitCode
     * @param string $unitHeadline
     * @param string[] $stateCodeList
     * @param string[] $countryCodeList
     * @param string $updatedAfter
     */
    public function __construct(\StructType\DateTimeSpanType $calendarDateRange = null, $propertyManagerCode = null, $unitCode = null, $unitName = null, $infoSource = null, $internalUnitCode = null, $unitHeadline = null, array $stateCodeList = array(), array $countryCodeList = array(), $updatedAfter = null)
    {
        $this
            ->setCalendarDateRange($calendarDateRange)
            ->setPropertyManagerCode($propertyManagerCode)
            ->setUnitCode($unitCode)
            ->setUnitName($unitName)
            ->setInfoSource($infoSource)
            ->setInternalUnitCode($internalUnitCode)
            ->setUnitHeadline($unitHeadline)
            ->setStateCodeList($stateCodeList)
            ->setCountryCodeList($countryCodeList)
            ->setUpdatedAfter($updatedAfter);
    }
    /**
     * Get CalendarDateRange value
     * @return \StructType\DateTimeSpanType|null
     */
    public function getCalendarDateRange()
    {
        return $this->CalendarDateRange;
    }
    /**
     * Set CalendarDateRange value
     * @param \StructType\DateTimeSpanType $calendarDateRange
     * @return \StructType\CalendarAvailType
     */
    public function setCalendarDateRange(\StructType\DateTimeSpanType $calendarDateRange = null)
    {
        $this->CalendarDateRange = $calendarDateRange;
        return $this;
    }
    /**
     * Get PropertyManagerCode value
     * @return string|null
     */
    public function getPropertyManagerCode()
    {
        return $this->PropertyManagerCode;
    }
    /**
     * Set PropertyManagerCode value
     * @param string $propertyManagerCode
     * @return \StructType\CalendarAvailType
     */
    public function setPropertyManagerCode($propertyManagerCode = null)
    {
        // validation for constraint: string
        if (!is_null($propertyManagerCode) && !is_string($propertyManagerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyManagerCode, true), gettype($propertyManagerCode)), __LINE__);
        }
        $this->PropertyManagerCode = $propertyManagerCode;
        return $this;
    }
    /**
     * Get UnitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->UnitCode;
    }
    /**
     * Set UnitCode value
     * @param string $unitCode
     * @return \StructType\CalendarAvailType
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitCode, true), gettype($unitCode)), __LINE__);
        }
        $this->UnitCode = $unitCode;
        return $this;
    }
    /**
     * Get UnitName value
     * @return string|null
     */
    public function getUnitName()
    {
        return $this->UnitName;
    }
    /**
     * Set UnitName value
     * @param string $unitName
     * @return \StructType\CalendarAvailType
     */
    public function setUnitName($unitName = null)
    {
        // validation for constraint: string
        if (!is_null($unitName) && !is_string($unitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitName, true), gettype($unitName)), __LINE__);
        }
        $this->UnitName = $unitName;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \StructType\CalendarAvailType
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoSource, true), gettype($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get InternalUnitCode value
     * @return string|null
     */
    public function getInternalUnitCode()
    {
        return $this->InternalUnitCode;
    }
    /**
     * Set InternalUnitCode value
     * @param string $internalUnitCode
     * @return \StructType\CalendarAvailType
     */
    public function setInternalUnitCode($internalUnitCode = null)
    {
        // validation for constraint: string
        if (!is_null($internalUnitCode) && !is_string($internalUnitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalUnitCode, true), gettype($internalUnitCode)), __LINE__);
        }
        $this->InternalUnitCode = $internalUnitCode;
        return $this;
    }
    /**
     * Get UnitHeadline value
     * @return string|null
     */
    public function getUnitHeadline()
    {
        return $this->UnitHeadline;
    }
    /**
     * Set UnitHeadline value
     * @param string $unitHeadline
     * @return \StructType\CalendarAvailType
     */
    public function setUnitHeadline($unitHeadline = null)
    {
        // validation for constraint: string
        if (!is_null($unitHeadline) && !is_string($unitHeadline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitHeadline, true), gettype($unitHeadline)), __LINE__);
        }
        $this->UnitHeadline = $unitHeadline;
        return $this;
    }
    /**
     * Get StateCodeList value
     * @return string[]|null
     */
    public function getStateCodeList()
    {
        return $this->StateCodeList;
    }
    /**
     * This method is responsible for validating the values passed to the setStateCodeList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStateCodeList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStateCodeListForArrayConstraintsFromSetStateCodeList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $calendarAvailTypeStateCodeListItem) {
            // validation for constraint: itemType
            if (!is_string($calendarAvailTypeStateCodeListItem)) {
                $invalidValues[] = is_object($calendarAvailTypeStateCodeListItem) ? get_class($calendarAvailTypeStateCodeListItem) : sprintf('%s(%s)', gettype($calendarAvailTypeStateCodeListItem), var_export($calendarAvailTypeStateCodeListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StateCodeList property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StateCodeList value
     * @throws \InvalidArgumentException
     * @param string[] $stateCodeList
     * @return \StructType\CalendarAvailType
     */
    public function setStateCodeList(array $stateCodeList = array())
    {
        // validation for constraint: array
        if ('' !== ($stateCodeListArrayErrorMessage = self::validateStateCodeListForArrayConstraintsFromSetStateCodeList($stateCodeList))) {
            throw new \InvalidArgumentException($stateCodeListArrayErrorMessage, __LINE__);
        }
        $this->StateCodeList = $stateCodeList;
        return $this;
    }
    /**
     * Add item to StateCodeList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CalendarAvailType
     */
    public function addToStateCodeList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The StateCodeList property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->StateCodeList[] = $item;
        return $this;
    }
    /**
     * Get CountryCodeList value
     * @return string[]|null
     */
    public function getCountryCodeList()
    {
        return $this->CountryCodeList;
    }
    /**
     * This method is responsible for validating the values passed to the setCountryCodeList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCountryCodeList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCountryCodeListForArrayConstraintsFromSetCountryCodeList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $calendarAvailTypeCountryCodeListItem) {
            // validation for constraint: itemType
            if (!is_string($calendarAvailTypeCountryCodeListItem)) {
                $invalidValues[] = is_object($calendarAvailTypeCountryCodeListItem) ? get_class($calendarAvailTypeCountryCodeListItem) : sprintf('%s(%s)', gettype($calendarAvailTypeCountryCodeListItem), var_export($calendarAvailTypeCountryCodeListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CountryCodeList property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CountryCodeList value
     * @throws \InvalidArgumentException
     * @param string[] $countryCodeList
     * @return \StructType\CalendarAvailType
     */
    public function setCountryCodeList(array $countryCodeList = array())
    {
        // validation for constraint: array
        if ('' !== ($countryCodeListArrayErrorMessage = self::validateCountryCodeListForArrayConstraintsFromSetCountryCodeList($countryCodeList))) {
            throw new \InvalidArgumentException($countryCodeListArrayErrorMessage, __LINE__);
        }
        $this->CountryCodeList = $countryCodeList;
        return $this;
    }
    /**
     * Add item to CountryCodeList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CalendarAvailType
     */
    public function addToCountryCodeList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CountryCodeList property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CountryCodeList[] = $item;
        return $this;
    }
    /**
     * Get UpdatedAfter value
     * @return string|null
     */
    public function getUpdatedAfter()
    {
        return $this->UpdatedAfter;
    }
    /**
     * Set UpdatedAfter value
     * @param string $updatedAfter
     * @return \StructType\CalendarAvailType
     */
    public function setUpdatedAfter($updatedAfter = null)
    {
        // validation for constraint: string
        if (!is_null($updatedAfter) && !is_string($updatedAfter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updatedAfter, true), gettype($updatedAfter)), __LINE__);
        }
        $this->UpdatedAfter = $updatedAfter;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CalendarAvailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
