<?php

namespace EnumType;

/**
 * This class stands for PreferredContactMethodType EnumType
 * @subpackage Enumerations
 */
class PreferredContactMethodType
{
    /**
     * Constant for value 'Email'
     * @return string 'Email'
     */
    const VALUE_EMAIL = 'Email';
    /**
     * Constant for value 'Telephone'
     * @return string 'Telephone'
     */
    const VALUE_TELEPHONE = 'Telephone';
    /**
     * Constant for value 'NoPreference'
     * @return string 'NoPreference'
     */
    const VALUE_NO_PREFERENCE = 'NoPreference';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EMAIL
     * @uses self::VALUE_TELEPHONE
     * @uses self::VALUE_NO_PREFERENCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EMAIL,
            self::VALUE_TELEPHONE,
            self::VALUE_NO_PREFERENCE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
