<?php

namespace EnumType;

/**
 * This class stands for RateTypeType EnumType
 * @subpackage Enumerations
 */
class RateTypeType
{
    /**
     * Constant for value 'Nightly'
     * @return string 'Nightly'
     */
    const VALUE_NIGHTLY = 'Nightly';
    /**
     * Constant for value 'Weekly'
     * @return string 'Weekly'
     */
    const VALUE_WEEKLY = 'Weekly';
    /**
     * Constant for value 'Monthly'
     * @return string 'Monthly'
     */
    const VALUE_MONTHLY = 'Monthly';
    /**
     * Constant for value 'Weekend'
     * @return string 'Weekend'
     */
    const VALUE_WEEKEND = 'Weekend';
    /**
     * Constant for value 'Midweek'
     * @return string 'Midweek'
     */
    const VALUE_MIDWEEK = 'Midweek';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NIGHTLY
     * @uses self::VALUE_WEEKLY
     * @uses self::VALUE_MONTHLY
     * @uses self::VALUE_WEEKEND
     * @uses self::VALUE_MIDWEEK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NIGHTLY,
            self::VALUE_WEEKLY,
            self::VALUE_MONTHLY,
            self::VALUE_WEEKEND,
            self::VALUE_MIDWEEK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
