<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadRequest StructType
 * @subpackage Structs
 */
class ReadRequest extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The Verification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VerificationType
     */
    public $Verification;
    /**
     * The HistoryRequestedInd
     * @var bool
     */
    public $HistoryRequestedInd;
    /**
     * Constructor method for ReadRequest
     * @uses ReadRequest::setUniqueID()
     * @uses ReadRequest::setVerification()
     * @uses ReadRequest::setHistoryRequestedInd()
     * @param \StructType\UniqueID_Type $uniqueID
     * @param \StructType\VerificationType $verification
     * @param bool $historyRequestedInd
     */
    public function __construct(\StructType\UniqueID_Type $uniqueID = null, \StructType\VerificationType $verification = null, $historyRequestedInd = null)
    {
        $this
            ->setUniqueID($uniqueID)
            ->setVerification($verification)
            ->setHistoryRequestedInd($historyRequestedInd);
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \StructType\UniqueID_Type $uniqueID
     * @return \StructType\ReadRequest
     */
    public function setUniqueID(\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get Verification value
     * @return \StructType\VerificationType|null
     */
    public function getVerification()
    {
        return $this->Verification;
    }
    /**
     * Set Verification value
     * @param \StructType\VerificationType $verification
     * @return \StructType\ReadRequest
     */
    public function setVerification(\StructType\VerificationType $verification = null)
    {
        $this->Verification = $verification;
        return $this;
    }
    /**
     * Get HistoryRequestedInd value
     * @return bool|null
     */
    public function getHistoryRequestedInd()
    {
        return $this->HistoryRequestedInd;
    }
    /**
     * Set HistoryRequestedInd value
     * @param bool $historyRequestedInd
     * @return \StructType\ReadRequest
     */
    public function setHistoryRequestedInd($historyRequestedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($historyRequestedInd) && !is_bool($historyRequestedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($historyRequestedInd, true), gettype($historyRequestedInd)), __LINE__);
        }
        $this->HistoryRequestedInd = $historyRequestedInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
