<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleCoreType StructType
 * @subpackage Structs
 */
class VehicleCoreType extends AbstractStructBase
{
    /**
     * The VehType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VehType
     */
    public $VehType;
    /**
     * The VehClass
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VehClass
     */
    public $VehClass;
    /**
     * The AirConditionInd
     * @var bool
     */
    public $AirConditionInd;
    /**
     * The TransmissionType
     * @var string
     */
    public $TransmissionType;
    /**
     * The FuelType
     * @var string
     */
    public $FuelType;
    /**
     * The DriveType
     * @var string
     */
    public $DriveType;
    /**
     * Constructor method for VehicleCoreType
     * @uses VehicleCoreType::setVehType()
     * @uses VehicleCoreType::setVehClass()
     * @uses VehicleCoreType::setAirConditionInd()
     * @uses VehicleCoreType::setTransmissionType()
     * @uses VehicleCoreType::setFuelType()
     * @uses VehicleCoreType::setDriveType()
     * @param \StructType\VehType $vehType
     * @param \StructType\VehClass $vehClass
     * @param bool $airConditionInd
     * @param string $transmissionType
     * @param string $fuelType
     * @param string $driveType
     */
    public function __construct(\StructType\VehType $vehType = null, \StructType\VehClass $vehClass = null, $airConditionInd = null, $transmissionType = null, $fuelType = null, $driveType = null)
    {
        $this
            ->setVehType($vehType)
            ->setVehClass($vehClass)
            ->setAirConditionInd($airConditionInd)
            ->setTransmissionType($transmissionType)
            ->setFuelType($fuelType)
            ->setDriveType($driveType);
    }
    /**
     * Get VehType value
     * @return \StructType\VehType|null
     */
    public function getVehType()
    {
        return $this->VehType;
    }
    /**
     * Set VehType value
     * @param \StructType\VehType $vehType
     * @return \StructType\VehicleCoreType
     */
    public function setVehType(\StructType\VehType $vehType = null)
    {
        $this->VehType = $vehType;
        return $this;
    }
    /**
     * Get VehClass value
     * @return \StructType\VehClass|null
     */
    public function getVehClass()
    {
        return $this->VehClass;
    }
    /**
     * Set VehClass value
     * @param \StructType\VehClass $vehClass
     * @return \StructType\VehicleCoreType
     */
    public function setVehClass(\StructType\VehClass $vehClass = null)
    {
        $this->VehClass = $vehClass;
        return $this;
    }
    /**
     * Get AirConditionInd value
     * @return bool|null
     */
    public function getAirConditionInd()
    {
        return $this->AirConditionInd;
    }
    /**
     * Set AirConditionInd value
     * @param bool $airConditionInd
     * @return \StructType\VehicleCoreType
     */
    public function setAirConditionInd($airConditionInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($airConditionInd) && !is_bool($airConditionInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($airConditionInd, true), gettype($airConditionInd)), __LINE__);
        }
        $this->AirConditionInd = $airConditionInd;
        return $this;
    }
    /**
     * Get TransmissionType value
     * @return string|null
     */
    public function getTransmissionType()
    {
        return $this->TransmissionType;
    }
    /**
     * Set TransmissionType value
     * @uses \EnumType\VehicleTransmissionType::valueIsValid()
     * @uses \EnumType\VehicleTransmissionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transmissionType
     * @return \StructType\VehicleCoreType
     */
    public function setTransmissionType($transmissionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleTransmissionType::valueIsValid($transmissionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VehicleTransmissionType', is_array($transmissionType) ? implode(', ', $transmissionType) : var_export($transmissionType, true), implode(', ', \EnumType\VehicleTransmissionType::getValidValues())), __LINE__);
        }
        $this->TransmissionType = $transmissionType;
        return $this;
    }
    /**
     * Get FuelType value
     * @return string|null
     */
    public function getFuelType()
    {
        return $this->FuelType;
    }
    /**
     * Set FuelType value
     * @param string $fuelType
     * @return \StructType\VehicleCoreType
     */
    public function setFuelType($fuelType = null)
    {
        // validation for constraint: string
        if (!is_null($fuelType) && !is_string($fuelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fuelType, true), gettype($fuelType)), __LINE__);
        }
        $this->FuelType = $fuelType;
        return $this;
    }
    /**
     * Get DriveType value
     * @return string|null
     */
    public function getDriveType()
    {
        return $this->DriveType;
    }
    /**
     * Set DriveType value
     * @param string $driveType
     * @return \StructType\VehicleCoreType
     */
    public function setDriveType($driveType = null)
    {
        // validation for constraint: string
        if (!is_null($driveType) && !is_string($driveType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driveType, true), gettype($driveType)), __LINE__);
        }
        $this->DriveType = $driveType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleCoreType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
