<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EVRN_CategoryCodesType StructType
 * @subpackage Structs
 */
class EVRN_CategoryCodesType extends AbstractStructBase
{
    /**
     * The LocationCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LocationCategory[]
     */
    public $LocationCategory;
    /**
     * The UnitCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UnitCategory[]
     */
    public $UnitCategory;
    /**
     * The RoomInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoomInfo[]
     */
    public $RoomInfo;
    /**
     * The BedInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BedInfo[]
     */
    public $BedInfo;
    /**
     * The PropertyManagerCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PropertyManagerCategory[]
     */
    public $PropertyManagerCategory;
    /**
     * The CustomCategoryGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomCategoryGroupType[]
     */
    public $CustomCategoryGroup;
    /**
     * Constructor method for EVRN_CategoryCodesType
     * @uses EVRN_CategoryCodesType::setLocationCategory()
     * @uses EVRN_CategoryCodesType::setUnitCategory()
     * @uses EVRN_CategoryCodesType::setRoomInfo()
     * @uses EVRN_CategoryCodesType::setBedInfo()
     * @uses EVRN_CategoryCodesType::setPropertyManagerCategory()
     * @uses EVRN_CategoryCodesType::setCustomCategoryGroup()
     * @param \StructType\LocationCategory[] $locationCategory
     * @param \StructType\UnitCategory[] $unitCategory
     * @param \StructType\RoomInfo[] $roomInfo
     * @param \StructType\BedInfo[] $bedInfo
     * @param \StructType\PropertyManagerCategory[] $propertyManagerCategory
     * @param \StructType\CustomCategoryGroupType[] $customCategoryGroup
     */
    public function __construct(array $locationCategory = array(), array $unitCategory = array(), array $roomInfo = array(), array $bedInfo = array(), array $propertyManagerCategory = array(), array $customCategoryGroup = array())
    {
        $this
            ->setLocationCategory($locationCategory)
            ->setUnitCategory($unitCategory)
            ->setRoomInfo($roomInfo)
            ->setBedInfo($bedInfo)
            ->setPropertyManagerCategory($propertyManagerCategory)
            ->setCustomCategoryGroup($customCategoryGroup);
    }
    /**
     * Get LocationCategory value
     * @return \StructType\LocationCategory[]|null
     */
    public function getLocationCategory()
    {
        return $this->LocationCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setLocationCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocationCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationCategoryForArrayConstraintsFromSetLocationCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eVRN_CategoryCodesTypeLocationCategoryItem) {
            // validation for constraint: itemType
            if (!$eVRN_CategoryCodesTypeLocationCategoryItem instanceof \StructType\LocationCategory) {
                $invalidValues[] = is_object($eVRN_CategoryCodesTypeLocationCategoryItem) ? get_class($eVRN_CategoryCodesTypeLocationCategoryItem) : sprintf('%s(%s)', gettype($eVRN_CategoryCodesTypeLocationCategoryItem), var_export($eVRN_CategoryCodesTypeLocationCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LocationCategory property can only contain items of type \StructType\LocationCategory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LocationCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationCategory[] $locationCategory
     * @return \StructType\EVRN_CategoryCodesType
     */
    public function setLocationCategory(array $locationCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($locationCategoryArrayErrorMessage = self::validateLocationCategoryForArrayConstraintsFromSetLocationCategory($locationCategory))) {
            throw new \InvalidArgumentException($locationCategoryArrayErrorMessage, __LINE__);
        }
        $this->LocationCategory = $locationCategory;
        return $this;
    }
    /**
     * Add item to LocationCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationCategory $item
     * @return \StructType\EVRN_CategoryCodesType
     */
    public function addToLocationCategory(\StructType\LocationCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationCategory) {
            throw new \InvalidArgumentException(sprintf('The LocationCategory property can only contain items of type \StructType\LocationCategory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LocationCategory[] = $item;
        return $this;
    }
    /**
     * Get UnitCategory value
     * @return \StructType\UnitCategory[]|null
     */
    public function getUnitCategory()
    {
        return $this->UnitCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setUnitCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitCategoryForArrayConstraintsFromSetUnitCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eVRN_CategoryCodesTypeUnitCategoryItem) {
            // validation for constraint: itemType
            if (!$eVRN_CategoryCodesTypeUnitCategoryItem instanceof \StructType\UnitCategory) {
                $invalidValues[] = is_object($eVRN_CategoryCodesTypeUnitCategoryItem) ? get_class($eVRN_CategoryCodesTypeUnitCategoryItem) : sprintf('%s(%s)', gettype($eVRN_CategoryCodesTypeUnitCategoryItem), var_export($eVRN_CategoryCodesTypeUnitCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UnitCategory property can only contain items of type \StructType\UnitCategory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UnitCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitCategory[] $unitCategory
     * @return \StructType\EVRN_CategoryCodesType
     */
    public function setUnitCategory(array $unitCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($unitCategoryArrayErrorMessage = self::validateUnitCategoryForArrayConstraintsFromSetUnitCategory($unitCategory))) {
            throw new \InvalidArgumentException($unitCategoryArrayErrorMessage, __LINE__);
        }
        $this->UnitCategory = $unitCategory;
        return $this;
    }
    /**
     * Add item to UnitCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitCategory $item
     * @return \StructType\EVRN_CategoryCodesType
     */
    public function addToUnitCategory(\StructType\UnitCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UnitCategory) {
            throw new \InvalidArgumentException(sprintf('The UnitCategory property can only contain items of type \StructType\UnitCategory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UnitCategory[] = $item;
        return $this;
    }
    /**
     * Get RoomInfo value
     * @return \StructType\RoomInfo[]|null
     */
    public function getRoomInfo()
    {
        return $this->RoomInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomInfoForArrayConstraintsFromSetRoomInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eVRN_CategoryCodesTypeRoomInfoItem) {
            // validation for constraint: itemType
            if (!$eVRN_CategoryCodesTypeRoomInfoItem instanceof \StructType\RoomInfo) {
                $invalidValues[] = is_object($eVRN_CategoryCodesTypeRoomInfoItem) ? get_class($eVRN_CategoryCodesTypeRoomInfoItem) : sprintf('%s(%s)', gettype($eVRN_CategoryCodesTypeRoomInfoItem), var_export($eVRN_CategoryCodesTypeRoomInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomInfo property can only contain items of type \StructType\RoomInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomInfo[] $roomInfo
     * @return \StructType\EVRN_CategoryCodesType
     */
    public function setRoomInfo(array $roomInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($roomInfoArrayErrorMessage = self::validateRoomInfoForArrayConstraintsFromSetRoomInfo($roomInfo))) {
            throw new \InvalidArgumentException($roomInfoArrayErrorMessage, __LINE__);
        }
        $this->RoomInfo = $roomInfo;
        return $this;
    }
    /**
     * Add item to RoomInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomInfo $item
     * @return \StructType\EVRN_CategoryCodesType
     */
    public function addToRoomInfo(\StructType\RoomInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomInfo) {
            throw new \InvalidArgumentException(sprintf('The RoomInfo property can only contain items of type \StructType\RoomInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoomInfo[] = $item;
        return $this;
    }
    /**
     * Get BedInfo value
     * @return \StructType\BedInfo[]|null
     */
    public function getBedInfo()
    {
        return $this->BedInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setBedInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBedInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBedInfoForArrayConstraintsFromSetBedInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eVRN_CategoryCodesTypeBedInfoItem) {
            // validation for constraint: itemType
            if (!$eVRN_CategoryCodesTypeBedInfoItem instanceof \StructType\BedInfo) {
                $invalidValues[] = is_object($eVRN_CategoryCodesTypeBedInfoItem) ? get_class($eVRN_CategoryCodesTypeBedInfoItem) : sprintf('%s(%s)', gettype($eVRN_CategoryCodesTypeBedInfoItem), var_export($eVRN_CategoryCodesTypeBedInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BedInfo property can only contain items of type \StructType\BedInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BedInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\BedInfo[] $bedInfo
     * @return \StructType\EVRN_CategoryCodesType
     */
    public function setBedInfo(array $bedInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($bedInfoArrayErrorMessage = self::validateBedInfoForArrayConstraintsFromSetBedInfo($bedInfo))) {
            throw new \InvalidArgumentException($bedInfoArrayErrorMessage, __LINE__);
        }
        $this->BedInfo = $bedInfo;
        return $this;
    }
    /**
     * Add item to BedInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\BedInfo $item
     * @return \StructType\EVRN_CategoryCodesType
     */
    public function addToBedInfo(\StructType\BedInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BedInfo) {
            throw new \InvalidArgumentException(sprintf('The BedInfo property can only contain items of type \StructType\BedInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BedInfo[] = $item;
        return $this;
    }
    /**
     * Get PropertyManagerCategory value
     * @return \StructType\PropertyManagerCategory[]|null
     */
    public function getPropertyManagerCategory()
    {
        return $this->PropertyManagerCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setPropertyManagerCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPropertyManagerCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropertyManagerCategoryForArrayConstraintsFromSetPropertyManagerCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eVRN_CategoryCodesTypePropertyManagerCategoryItem) {
            // validation for constraint: itemType
            if (!$eVRN_CategoryCodesTypePropertyManagerCategoryItem instanceof \StructType\PropertyManagerCategory) {
                $invalidValues[] = is_object($eVRN_CategoryCodesTypePropertyManagerCategoryItem) ? get_class($eVRN_CategoryCodesTypePropertyManagerCategoryItem) : sprintf('%s(%s)', gettype($eVRN_CategoryCodesTypePropertyManagerCategoryItem), var_export($eVRN_CategoryCodesTypePropertyManagerCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PropertyManagerCategory property can only contain items of type \StructType\PropertyManagerCategory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PropertyManagerCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\PropertyManagerCategory[] $propertyManagerCategory
     * @return \StructType\EVRN_CategoryCodesType
     */
    public function setPropertyManagerCategory(array $propertyManagerCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($propertyManagerCategoryArrayErrorMessage = self::validatePropertyManagerCategoryForArrayConstraintsFromSetPropertyManagerCategory($propertyManagerCategory))) {
            throw new \InvalidArgumentException($propertyManagerCategoryArrayErrorMessage, __LINE__);
        }
        $this->PropertyManagerCategory = $propertyManagerCategory;
        return $this;
    }
    /**
     * Add item to PropertyManagerCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\PropertyManagerCategory $item
     * @return \StructType\EVRN_CategoryCodesType
     */
    public function addToPropertyManagerCategory(\StructType\PropertyManagerCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PropertyManagerCategory) {
            throw new \InvalidArgumentException(sprintf('The PropertyManagerCategory property can only contain items of type \StructType\PropertyManagerCategory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PropertyManagerCategory[] = $item;
        return $this;
    }
    /**
     * Get CustomCategoryGroup value
     * @return \StructType\CustomCategoryGroupType[]|null
     */
    public function getCustomCategoryGroup()
    {
        return $this->CustomCategoryGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomCategoryGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomCategoryGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomCategoryGroupForArrayConstraintsFromSetCustomCategoryGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eVRN_CategoryCodesTypeCustomCategoryGroupItem) {
            // validation for constraint: itemType
            if (!$eVRN_CategoryCodesTypeCustomCategoryGroupItem instanceof \StructType\CustomCategoryGroupType) {
                $invalidValues[] = is_object($eVRN_CategoryCodesTypeCustomCategoryGroupItem) ? get_class($eVRN_CategoryCodesTypeCustomCategoryGroupItem) : sprintf('%s(%s)', gettype($eVRN_CategoryCodesTypeCustomCategoryGroupItem), var_export($eVRN_CategoryCodesTypeCustomCategoryGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomCategoryGroup property can only contain items of type \StructType\CustomCategoryGroupType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomCategoryGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomCategoryGroupType[] $customCategoryGroup
     * @return \StructType\EVRN_CategoryCodesType
     */
    public function setCustomCategoryGroup(array $customCategoryGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($customCategoryGroupArrayErrorMessage = self::validateCustomCategoryGroupForArrayConstraintsFromSetCustomCategoryGroup($customCategoryGroup))) {
            throw new \InvalidArgumentException($customCategoryGroupArrayErrorMessage, __LINE__);
        }
        $this->CustomCategoryGroup = $customCategoryGroup;
        return $this;
    }
    /**
     * Add item to CustomCategoryGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomCategoryGroupType $item
     * @return \StructType\EVRN_CategoryCodesType
     */
    public function addToCustomCategoryGroup(\StructType\CustomCategoryGroupType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomCategoryGroupType) {
            throw new \InvalidArgumentException(sprintf('The CustomCategoryGroup property can only contain items of type \StructType\CustomCategoryGroupType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomCategoryGroup[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EVRN_CategoryCodesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
