<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitRate StructType
 * @subpackage Structs
 */
class UnitRate extends AbstractStructBase
{
    /**
     * The Rates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEVRN_AmountType
     */
    public $Rates;
    /**
     * The UnitRateDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ParagraphType
     */
    public $UnitRateDescription;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TotalType
     */
    public $Total;
    /**
     * Constructor method for UnitRate
     * @uses UnitRate::setRates()
     * @uses UnitRate::setUnitRateDescription()
     * @uses UnitRate::setTotal()
     * @param \ArrayType\ArrayOfEVRN_AmountType $rates
     * @param \StructType\ParagraphType $unitRateDescription
     * @param \StructType\TotalType $total
     */
    public function __construct(\ArrayType\ArrayOfEVRN_AmountType $rates = null, \StructType\ParagraphType $unitRateDescription = null, \StructType\TotalType $total = null)
    {
        $this
            ->setRates($rates)
            ->setUnitRateDescription($unitRateDescription)
            ->setTotal($total);
    }
    /**
     * Get Rates value
     * @return \ArrayType\ArrayOfEVRN_AmountType|null
     */
    public function getRates()
    {
        return $this->Rates;
    }
    /**
     * Set Rates value
     * @param \ArrayType\ArrayOfEVRN_AmountType $rates
     * @return \StructType\UnitRate
     */
    public function setRates(\ArrayType\ArrayOfEVRN_AmountType $rates = null)
    {
        $this->Rates = $rates;
        return $this;
    }
    /**
     * Get UnitRateDescription value
     * @return \StructType\ParagraphType|null
     */
    public function getUnitRateDescription()
    {
        return $this->UnitRateDescription;
    }
    /**
     * Set UnitRateDescription value
     * @param \StructType\ParagraphType $unitRateDescription
     * @return \StructType\UnitRate
     */
    public function setUnitRateDescription(\StructType\ParagraphType $unitRateDescription = null)
    {
        $this->UnitRateDescription = $unitRateDescription;
        return $this;
    }
    /**
     * Get Total value
     * @return \StructType\TotalType|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \StructType\TotalType $total
     * @return \StructType\UnitRate
     */
    public function setTotal(\StructType\TotalType $total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnitRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
