<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegionType StructType
 * Meta information extracted from the WSDL
 * - mixed: false
 * @subpackage Structs
 */
class RegionType extends RegionIdentifierType
{
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PostalCode;
    /**
     * Constructor method for RegionType
     * @uses RegionType::setCountryCode()
     * @uses RegionType::setPostalCode()
     * @param string $countryCode
     * @param string[] $postalCode
     */
    public function __construct($countryCode = null, array $postalCode = array())
    {
        $this
            ->setCountryCode($countryCode)
            ->setPostalCode($postalCode);
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\RegionType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string[]|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * This method is responsible for validating the values passed to the setPostalCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPostalCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePostalCodeForArrayConstraintsFromSetPostalCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $regionTypePostalCodeItem) {
            // validation for constraint: itemType
            if (!is_string($regionTypePostalCodeItem)) {
                $invalidValues[] = is_object($regionTypePostalCodeItem) ? get_class($regionTypePostalCodeItem) : sprintf('%s(%s)', gettype($regionTypePostalCodeItem), var_export($regionTypePostalCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PostalCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PostalCode value
     * @throws \InvalidArgumentException
     * @param string[] $postalCode
     * @return \StructType\RegionType
     */
    public function setPostalCode(array $postalCode = array())
    {
        // validation for constraint: array
        if ('' !== ($postalCodeArrayErrorMessage = self::validatePostalCodeForArrayConstraintsFromSetPostalCode($postalCode))) {
            throw new \InvalidArgumentException($postalCodeArrayErrorMessage, __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Add item to PostalCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\RegionType
     */
    public function addToPostalCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PostalCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PostalCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
