<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyClassPrefType StructType
 * @subpackage Structs
 */
class PropertyClassPrefType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The PropertyClassType
     * @var string
     */
    public $PropertyClassType;
    /**
     * Constructor method for PropertyClassPrefType
     * @uses PropertyClassPrefType::set_()
     * @uses PropertyClassPrefType::setPreferLevel()
     * @uses PropertyClassPrefType::setPropertyClassType()
     * @param string $_
     * @param string $preferLevel
     * @param string $propertyClassType
     */
    public function __construct($_ = null, $preferLevel = 'Preferred', $propertyClassType = null)
    {
        $this
            ->set_($_)
            ->setPreferLevel($preferLevel)
            ->setPropertyClassType($propertyClassType);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\PropertyClassPrefType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\PropertyClassPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get PropertyClassType value
     * @return string|null
     */
    public function getPropertyClassType()
    {
        return $this->PropertyClassType;
    }
    /**
     * Set PropertyClassType value
     * @param string $propertyClassType
     * @return \StructType\PropertyClassPrefType
     */
    public function setPropertyClassType($propertyClassType = null)
    {
        // validation for constraint: string
        if (!is_null($propertyClassType) && !is_string($propertyClassType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyClassType, true), gettype($propertyClassType)), __LINE__);
        }
        $this->PropertyClassType = $propertyClassType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PropertyClassPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
