<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResGuest StructType
 * @subpackage Structs
 */
class ResGuest extends AbstractStructBase
{
    /**
     * The Profiles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProfilesTypeProfileInfo
     */
    public $Profiles;
    /**
     * The SpecialRequests
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSpecialRequestTypeSpecialRequest
     */
    public $SpecialRequests;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCommentTypeComment
     */
    public $Comments;
    /**
     * The ServiceRPHs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfServiceRPHsTypeServiceRPH
     */
    public $ServiceRPHs;
    /**
     * The ProfileRPHs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfResGuestsTypeResGuestProfileRPH
     */
    public $ProfileRPHs;
    /**
     * The ArrivalTransport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransportInfoType
     */
    public $ArrivalTransport;
    /**
     * The DepartureTransport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TransportInfoType
     */
    public $DepartureTransport;
    /**
     * The GuestCounts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GuestCountType
     */
    public $GuestCounts;
    /**
     * The InHouseTimeSpan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DateTimeSpanType
     */
    public $InHouseTimeSpan;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The ResGuestRPH
     * @var string
     */
    public $ResGuestRPH;
    /**
     * The AgeQualifyingCode
     * @var string
     */
    public $AgeQualifyingCode;
    /**
     * The ArrivalTime
     * @var string
     */
    public $ArrivalTime;
    /**
     * The DepartureTime
     * @var string
     */
    public $DepartureTime;
    /**
     * The GroupEventCode
     * @var string
     */
    public $GroupEventCode;
    /**
     * The VIP
     * @var bool
     */
    public $VIP;
    /**
     * Constructor method for ResGuest
     * @uses ResGuest::setProfiles()
     * @uses ResGuest::setSpecialRequests()
     * @uses ResGuest::setComments()
     * @uses ResGuest::setServiceRPHs()
     * @uses ResGuest::setProfileRPHs()
     * @uses ResGuest::setArrivalTransport()
     * @uses ResGuest::setDepartureTransport()
     * @uses ResGuest::setGuestCounts()
     * @uses ResGuest::setInHouseTimeSpan()
     * @uses ResGuest::setTPA_Extensions()
     * @uses ResGuest::setResGuestRPH()
     * @uses ResGuest::setAgeQualifyingCode()
     * @uses ResGuest::setArrivalTime()
     * @uses ResGuest::setDepartureTime()
     * @uses ResGuest::setGroupEventCode()
     * @uses ResGuest::setVIP()
     * @param \ArrayType\ArrayOfProfilesTypeProfileInfo $profiles
     * @param \ArrayType\ArrayOfSpecialRequestTypeSpecialRequest $specialRequests
     * @param \ArrayType\ArrayOfCommentTypeComment $comments
     * @param \ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs
     * @param \ArrayType\ArrayOfResGuestsTypeResGuestProfileRPH $profileRPHs
     * @param \StructType\TransportInfoType $arrivalTransport
     * @param \StructType\TransportInfoType $departureTransport
     * @param \StructType\GuestCountType $guestCounts
     * @param \StructType\DateTimeSpanType $inHouseTimeSpan
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     * @param string $resGuestRPH
     * @param string $ageQualifyingCode
     * @param string $arrivalTime
     * @param string $departureTime
     * @param string $groupEventCode
     * @param bool $vIP
     */
    public function __construct(\ArrayType\ArrayOfProfilesTypeProfileInfo $profiles = null, \ArrayType\ArrayOfSpecialRequestTypeSpecialRequest $specialRequests = null, \ArrayType\ArrayOfCommentTypeComment $comments = null, \ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs = null, \ArrayType\ArrayOfResGuestsTypeResGuestProfileRPH $profileRPHs = null, \StructType\TransportInfoType $arrivalTransport = null, \StructType\TransportInfoType $departureTransport = null, \StructType\GuestCountType $guestCounts = null, \StructType\DateTimeSpanType $inHouseTimeSpan = null, \StructType\TPA_Extensions_Type $tPA_Extensions = null, $resGuestRPH = null, $ageQualifyingCode = null, $arrivalTime = null, $departureTime = null, $groupEventCode = null, $vIP = null)
    {
        $this
            ->setProfiles($profiles)
            ->setSpecialRequests($specialRequests)
            ->setComments($comments)
            ->setServiceRPHs($serviceRPHs)
            ->setProfileRPHs($profileRPHs)
            ->setArrivalTransport($arrivalTransport)
            ->setDepartureTransport($departureTransport)
            ->setGuestCounts($guestCounts)
            ->setInHouseTimeSpan($inHouseTimeSpan)
            ->setTPA_Extensions($tPA_Extensions)
            ->setResGuestRPH($resGuestRPH)
            ->setAgeQualifyingCode($ageQualifyingCode)
            ->setArrivalTime($arrivalTime)
            ->setDepartureTime($departureTime)
            ->setGroupEventCode($groupEventCode)
            ->setVIP($vIP);
    }
    /**
     * Get Profiles value
     * @return \ArrayType\ArrayOfProfilesTypeProfileInfo|null
     */
    public function getProfiles()
    {
        return $this->Profiles;
    }
    /**
     * Set Profiles value
     * @param \ArrayType\ArrayOfProfilesTypeProfileInfo $profiles
     * @return \StructType\ResGuest
     */
    public function setProfiles(\ArrayType\ArrayOfProfilesTypeProfileInfo $profiles = null)
    {
        $this->Profiles = $profiles;
        return $this;
    }
    /**
     * Get SpecialRequests value
     * @return \ArrayType\ArrayOfSpecialRequestTypeSpecialRequest|null
     */
    public function getSpecialRequests()
    {
        return $this->SpecialRequests;
    }
    /**
     * Set SpecialRequests value
     * @param \ArrayType\ArrayOfSpecialRequestTypeSpecialRequest $specialRequests
     * @return \StructType\ResGuest
     */
    public function setSpecialRequests(\ArrayType\ArrayOfSpecialRequestTypeSpecialRequest $specialRequests = null)
    {
        $this->SpecialRequests = $specialRequests;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfCommentTypeComment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfCommentTypeComment $comments
     * @return \StructType\ResGuest
     */
    public function setComments(\ArrayType\ArrayOfCommentTypeComment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get ServiceRPHs value
     * @return \ArrayType\ArrayOfServiceRPHsTypeServiceRPH|null
     */
    public function getServiceRPHs()
    {
        return $this->ServiceRPHs;
    }
    /**
     * Set ServiceRPHs value
     * @param \ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs
     * @return \StructType\ResGuest
     */
    public function setServiceRPHs(\ArrayType\ArrayOfServiceRPHsTypeServiceRPH $serviceRPHs = null)
    {
        $this->ServiceRPHs = $serviceRPHs;
        return $this;
    }
    /**
     * Get ProfileRPHs value
     * @return \ArrayType\ArrayOfResGuestsTypeResGuestProfileRPH|null
     */
    public function getProfileRPHs()
    {
        return $this->ProfileRPHs;
    }
    /**
     * Set ProfileRPHs value
     * @param \ArrayType\ArrayOfResGuestsTypeResGuestProfileRPH $profileRPHs
     * @return \StructType\ResGuest
     */
    public function setProfileRPHs(\ArrayType\ArrayOfResGuestsTypeResGuestProfileRPH $profileRPHs = null)
    {
        $this->ProfileRPHs = $profileRPHs;
        return $this;
    }
    /**
     * Get ArrivalTransport value
     * @return \StructType\TransportInfoType|null
     */
    public function getArrivalTransport()
    {
        return $this->ArrivalTransport;
    }
    /**
     * Set ArrivalTransport value
     * @param \StructType\TransportInfoType $arrivalTransport
     * @return \StructType\ResGuest
     */
    public function setArrivalTransport(\StructType\TransportInfoType $arrivalTransport = null)
    {
        $this->ArrivalTransport = $arrivalTransport;
        return $this;
    }
    /**
     * Get DepartureTransport value
     * @return \StructType\TransportInfoType|null
     */
    public function getDepartureTransport()
    {
        return $this->DepartureTransport;
    }
    /**
     * Set DepartureTransport value
     * @param \StructType\TransportInfoType $departureTransport
     * @return \StructType\ResGuest
     */
    public function setDepartureTransport(\StructType\TransportInfoType $departureTransport = null)
    {
        $this->DepartureTransport = $departureTransport;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \StructType\GuestCountType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \StructType\GuestCountType $guestCounts
     * @return \StructType\ResGuest
     */
    public function setGuestCounts(\StructType\GuestCountType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get InHouseTimeSpan value
     * @return \StructType\DateTimeSpanType|null
     */
    public function getInHouseTimeSpan()
    {
        return $this->InHouseTimeSpan;
    }
    /**
     * Set InHouseTimeSpan value
     * @param \StructType\DateTimeSpanType $inHouseTimeSpan
     * @return \StructType\ResGuest
     */
    public function setInHouseTimeSpan(\StructType\DateTimeSpanType $inHouseTimeSpan = null)
    {
        $this->InHouseTimeSpan = $inHouseTimeSpan;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \StructType\ResGuest
     */
    public function setTPA_Extensions(\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ResGuestRPH value
     * @return string|null
     */
    public function getResGuestRPH()
    {
        return $this->ResGuestRPH;
    }
    /**
     * Set ResGuestRPH value
     * @param string $resGuestRPH
     * @return \StructType\ResGuest
     */
    public function setResGuestRPH($resGuestRPH = null)
    {
        // validation for constraint: string
        if (!is_null($resGuestRPH) && !is_string($resGuestRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resGuestRPH, true), gettype($resGuestRPH)), __LINE__);
        }
        $this->ResGuestRPH = $resGuestRPH;
        return $this;
    }
    /**
     * Get AgeQualifyingCode value
     * @return string|null
     */
    public function getAgeQualifyingCode()
    {
        return $this->AgeQualifyingCode;
    }
    /**
     * Set AgeQualifyingCode value
     * @param string $ageQualifyingCode
     * @return \StructType\ResGuest
     */
    public function setAgeQualifyingCode($ageQualifyingCode = null)
    {
        // validation for constraint: string
        if (!is_null($ageQualifyingCode) && !is_string($ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ageQualifyingCode, true), gettype($ageQualifyingCode)), __LINE__);
        }
        $this->AgeQualifyingCode = $ageQualifyingCode;
        return $this;
    }
    /**
     * Get ArrivalTime value
     * @return string|null
     */
    public function getArrivalTime()
    {
        return $this->ArrivalTime;
    }
    /**
     * Set ArrivalTime value
     * @param string $arrivalTime
     * @return \StructType\ResGuest
     */
    public function setArrivalTime($arrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalTime) && !is_string($arrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalTime, true), gettype($arrivalTime)), __LINE__);
        }
        $this->ArrivalTime = $arrivalTime;
        return $this;
    }
    /**
     * Get DepartureTime value
     * @return string|null
     */
    public function getDepartureTime()
    {
        return $this->DepartureTime;
    }
    /**
     * Set DepartureTime value
     * @param string $departureTime
     * @return \StructType\ResGuest
     */
    public function setDepartureTime($departureTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureTime) && !is_string($departureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureTime, true), gettype($departureTime)), __LINE__);
        }
        $this->DepartureTime = $departureTime;
        return $this;
    }
    /**
     * Get GroupEventCode value
     * @return string|null
     */
    public function getGroupEventCode()
    {
        return $this->GroupEventCode;
    }
    /**
     * Set GroupEventCode value
     * @param string $groupEventCode
     * @return \StructType\ResGuest
     */
    public function setGroupEventCode($groupEventCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupEventCode) && !is_string($groupEventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupEventCode, true), gettype($groupEventCode)), __LINE__);
        }
        $this->GroupEventCode = $groupEventCode;
        return $this;
    }
    /**
     * Get VIP value
     * @return bool|null
     */
    public function getVIP()
    {
        return $this->VIP;
    }
    /**
     * Set VIP value
     * @param bool $vIP
     * @return \StructType\ResGuest
     */
    public function setVIP($vIP = null)
    {
        // validation for constraint: boolean
        if (!is_null($vIP) && !is_bool($vIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vIP, true), gettype($vIP)), __LINE__);
        }
        $this->VIP = $vIP;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResGuest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
