<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EndDateWindow StructType
 * @subpackage Structs
 */
class EndDateWindow extends AbstractStructBase
{
    /**
     * The EarliestDate
     * @var string
     */
    public $EarliestDate;
    /**
     * The LatestDate
     * @var string
     */
    public $LatestDate;
    /**
     * The DOW
     * @var string
     */
    public $DOW;
    /**
     * Constructor method for EndDateWindow
     * @uses EndDateWindow::setEarliestDate()
     * @uses EndDateWindow::setLatestDate()
     * @uses EndDateWindow::setDOW()
     * @param string $earliestDate
     * @param string $latestDate
     * @param string $dOW
     */
    public function __construct($earliestDate = null, $latestDate = null, $dOW = null)
    {
        $this
            ->setEarliestDate($earliestDate)
            ->setLatestDate($latestDate)
            ->setDOW($dOW);
    }
    /**
     * Get EarliestDate value
     * @return string|null
     */
    public function getEarliestDate()
    {
        return $this->EarliestDate;
    }
    /**
     * Set EarliestDate value
     * @param string $earliestDate
     * @return \StructType\EndDateWindow
     */
    public function setEarliestDate($earliestDate = null)
    {
        // validation for constraint: string
        if (!is_null($earliestDate) && !is_string($earliestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($earliestDate, true), gettype($earliestDate)), __LINE__);
        }
        $this->EarliestDate = $earliestDate;
        return $this;
    }
    /**
     * Get LatestDate value
     * @return string|null
     */
    public function getLatestDate()
    {
        return $this->LatestDate;
    }
    /**
     * Set LatestDate value
     * @param string $latestDate
     * @return \StructType\EndDateWindow
     */
    public function setLatestDate($latestDate = null)
    {
        // validation for constraint: string
        if (!is_null($latestDate) && !is_string($latestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latestDate, true), gettype($latestDate)), __LINE__);
        }
        $this->LatestDate = $latestDate;
        return $this;
    }
    /**
     * Get DOW value
     * @return string|null
     */
    public function getDOW()
    {
        return $this->DOW;
    }
    /**
     * Set DOW value
     * @uses \EnumType\DayOfWeekType::valueIsValid()
     * @uses \EnumType\DayOfWeekType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dOW
     * @return \StructType\EndDateWindow
     */
    public function setDOW($dOW = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DayOfWeekType::valueIsValid($dOW)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DayOfWeekType', is_array($dOW) ? implode(', ', $dOW) : var_export($dOW, true), implode(', ', \EnumType\DayOfWeekType::getValidValues())), __LINE__);
        }
        $this->DOW = $dOW;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EndDateWindow
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
