<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessesType StructType
 * @subpackage Structs
 */
class AccessesType extends AbstractStructBase
{
    /**
     * The Access
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Access[]
     */
    public $Access;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The CreateDateTime
     * @var string
     */
    public $CreateDateTime;
    /**
     * Constructor method for AccessesType
     * @uses AccessesType::setAccess()
     * @uses AccessesType::setShareSynchInd()
     * @uses AccessesType::setShareMarketInd()
     * @uses AccessesType::setCreateDateTime()
     * @param \StructType\Access[] $access
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $createDateTime
     */
    public function __construct(array $access = array(), $shareSynchInd = null, $shareMarketInd = null, $createDateTime = null)
    {
        $this
            ->setAccess($access)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setCreateDateTime($createDateTime);
    }
    /**
     * Get Access value
     * @return \StructType\Access[]|null
     */
    public function getAccess()
    {
        return $this->Access;
    }
    /**
     * This method is responsible for validating the values passed to the setAccess method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccess method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccessForArrayConstraintsFromSetAccess(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accessesTypeAccessItem) {
            // validation for constraint: itemType
            if (!$accessesTypeAccessItem instanceof \StructType\Access) {
                $invalidValues[] = is_object($accessesTypeAccessItem) ? get_class($accessesTypeAccessItem) : sprintf('%s(%s)', gettype($accessesTypeAccessItem), var_export($accessesTypeAccessItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Access property can only contain items of type \StructType\Access, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Access value
     * @throws \InvalidArgumentException
     * @param \StructType\Access[] $access
     * @return \StructType\AccessesType
     */
    public function setAccess(array $access = array())
    {
        // validation for constraint: array
        if ('' !== ($accessArrayErrorMessage = self::validateAccessForArrayConstraintsFromSetAccess($access))) {
            throw new \InvalidArgumentException($accessArrayErrorMessage, __LINE__);
        }
        $this->Access = $access;
        return $this;
    }
    /**
     * Add item to Access value
     * @throws \InvalidArgumentException
     * @param \StructType\Access $item
     * @return \StructType\AccessesType
     */
    public function addToAccess(\StructType\Access $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Access) {
            throw new \InvalidArgumentException(sprintf('The Access property can only contain items of type \StructType\Access, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Access[] = $item;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\AccessesType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\AccessesType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \StructType\AccessesType
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateTime, true), gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccessesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
