<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BedTypePrefType StructType
 * @subpackage Structs
 */
class BedTypePrefType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The BedType
     * @var string
     */
    public $BedType;
    /**
     * Constructor method for BedTypePrefType
     * @uses BedTypePrefType::set_()
     * @uses BedTypePrefType::setPreferLevel()
     * @uses BedTypePrefType::setBedType()
     * @param string $_
     * @param string $preferLevel
     * @param string $bedType
     */
    public function __construct($_ = null, $preferLevel = 'Preferred', $bedType = null)
    {
        $this
            ->set_($_)
            ->setPreferLevel($preferLevel)
            ->setBedType($bedType);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\BedTypePrefType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\BedTypePrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get BedType value
     * @return string|null
     */
    public function getBedType()
    {
        return $this->BedType;
    }
    /**
     * Set BedType value
     * @param string $bedType
     * @return \StructType\BedTypePrefType
     */
    public function setBedType($bedType = null)
    {
        // validation for constraint: string
        if (!is_null($bedType) && !is_string($bedType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bedType, true), gettype($bedType)), __LINE__);
        }
        $this->BedType = $bedType;
        return $this;
    }
}
