<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressInfoType StructType
 * @subpackage Structs
 */
class AddressInfoType extends AddressType
{
    /**
     * The DefaultInd
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $DefaultInd;
    /**
     * The UseType
     * @var string
     */
    public $UseType;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for AddressInfoType
     * @uses AddressInfoType::setDefaultInd()
     * @uses AddressInfoType::setUseType()
     * @uses AddressInfoType::setRPH()
     * @param bool $defaultInd
     * @param string $useType
     * @param string $rPH
     */
    public function __construct($defaultInd = false, $useType = null, $rPH = null)
    {
        $this
            ->setDefaultInd($defaultInd)
            ->setUseType($useType)
            ->setRPH($rPH);
    }
    /**
     * Get DefaultInd value
     * @return bool|null
     */
    public function getDefaultInd()
    {
        return $this->DefaultInd;
    }
    /**
     * Set DefaultInd value
     * @param bool $defaultInd
     * @return \StructType\AddressInfoType
     */
    public function setDefaultInd($defaultInd = false)
    {
        // validation for constraint: boolean
        if (!is_null($defaultInd) && !is_bool($defaultInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultInd, true), gettype($defaultInd)), __LINE__);
        }
        $this->DefaultInd = $defaultInd;
        return $this;
    }
    /**
     * Get UseType value
     * @return string|null
     */
    public function getUseType()
    {
        return $this->UseType;
    }
    /**
     * Set UseType value
     * @param string $useType
     * @return \StructType\AddressInfoType
     */
    public function setUseType($useType = null)
    {
        // validation for constraint: string
        if (!is_null($useType) && !is_string($useType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useType, true), gettype($useType)), __LINE__);
        }
        $this->UseType = $useType;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\AddressInfoType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
}
