<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Unit ServiceType
 * @subpackage Services
 */
class Unit extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UnitDescriptiveInfoStream
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EVRN_UnitDescriptiveInfoRQ $eVRN_UnitDescriptiveInfoRQ
     * @return \StructType\UnitDescriptiveInfoStream|bool
     */
    public function UnitDescriptiveInfoStream(\StructType\EVRN_UnitDescriptiveInfoRQ $eVRN_UnitDescriptiveInfoRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->UnitDescriptiveInfoStream($eVRN_UnitDescriptiveInfoRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnitCalendarAvailBatch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EVRN_UnitCalendarAvailBatchRQ $eVRN_UnitCalendarAvailBatchRQ
     * @return \StructType\EVRN_UnitCalendarAvailBatchRS|bool
     */
    public function UnitCalendarAvailBatch(\StructType\EVRN_UnitCalendarAvailBatchRQ $eVRN_UnitCalendarAvailBatchRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->UnitCalendarAvailBatch($eVRN_UnitCalendarAvailBatchRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EVRN_UnitCalendarAvailBatchRS|\StructType\UnitDescriptiveInfoStream
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
