<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSpecialRequestTypeSpecialRequest ArrayType
 * @subpackage Arrays
 */
class ArrayOfSpecialRequestTypeSpecialRequest extends AbstractStructArrayBase
{
    /**
     * The SpecialRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SpecialRequest[]
     */
    public $SpecialRequest;
    /**
     * Constructor method for ArrayOfSpecialRequestTypeSpecialRequest
     * @uses ArrayOfSpecialRequestTypeSpecialRequest::setSpecialRequest()
     * @param \StructType\SpecialRequest[] $specialRequest
     */
    public function __construct(array $specialRequest = array())
    {
        $this
            ->setSpecialRequest($specialRequest);
    }
    /**
     * Get SpecialRequest value
     * @return \StructType\SpecialRequest[]|null
     */
    public function getSpecialRequest()
    {
        return $this->SpecialRequest;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialRequestForArrayConstraintsFromSetSpecialRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem instanceof \StructType\SpecialRequest) {
                $invalidValues[] = is_object($arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem) ? get_class($arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem) : sprintf('%s(%s)', gettype($arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem), var_export($arrayOfSpecialRequestTypeSpecialRequestSpecialRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialRequest property can only contain items of type \StructType\SpecialRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialRequest[] $specialRequest
     * @return \ArrayType\ArrayOfSpecialRequestTypeSpecialRequest
     */
    public function setSpecialRequest(array $specialRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($specialRequestArrayErrorMessage = self::validateSpecialRequestForArrayConstraintsFromSetSpecialRequest($specialRequest))) {
            throw new \InvalidArgumentException($specialRequestArrayErrorMessage, __LINE__);
        }
        $this->SpecialRequest = $specialRequest;
        return $this;
    }
    /**
     * Add item to SpecialRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialRequest $item
     * @return \ArrayType\ArrayOfSpecialRequestTypeSpecialRequest
     */
    public function addToSpecialRequest(\StructType\SpecialRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecialRequest) {
            throw new \InvalidArgumentException(sprintf('The SpecialRequest property can only contain items of type \StructType\SpecialRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecialRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SpecialRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SpecialRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SpecialRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SpecialRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SpecialRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SpecialRequest
     */
    public function getAttributeName()
    {
        return 'SpecialRequest';
    }
}
