<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitRate StructType
 * @subpackage Structs
 */
class UnitRate extends AbstractStructBase
{
    /**
     * The Rates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEVRN_AmountType
     */
    public $Rates;
    /**
     * The UnitRateDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ParagraphType
     */
    public $UnitRateDescription;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TotalType
     */
    public $Total;
    /**
     * Constructor method for UnitRate
     * @uses UnitRate::setRates()
     * @uses UnitRate::setUnitRateDescription()
     * @uses UnitRate::setTotal()
     * @param \ArrayType\ArrayOfEVRN_AmountType $rates
     * @param \StructType\ParagraphType $unitRateDescription
     * @param \StructType\TotalType $total
     */
    public function __construct(\ArrayType\ArrayOfEVRN_AmountType $rates = null, \StructType\ParagraphType $unitRateDescription = null, \StructType\TotalType $total = null)
    {
        $this
            ->setRates($rates)
            ->setUnitRateDescription($unitRateDescription)
            ->setTotal($total);
    }
    /**
     * Get Rates value
     * @return \ArrayType\ArrayOfEVRN_AmountType|null
     */
    public function getRates()
    {
        return $this->Rates;
    }
    /**
     * Set Rates value
     * @param \ArrayType\ArrayOfEVRN_AmountType $rates
     * @return \StructType\UnitRate
     */
    public function setRates(\ArrayType\ArrayOfEVRN_AmountType $rates = null)
    {
        $this->Rates = $rates;
        return $this;
    }
    /**
     * Get UnitRateDescription value
     * @return \StructType\ParagraphType|null
     */
    public function getUnitRateDescription()
    {
        return $this->UnitRateDescription;
    }
    /**
     * Set UnitRateDescription value
     * @param \StructType\ParagraphType $unitRateDescription
     * @return \StructType\UnitRate
     */
    public function setUnitRateDescription(\StructType\ParagraphType $unitRateDescription = null)
    {
        $this->UnitRateDescription = $unitRateDescription;
        return $this;
    }
    /**
     * Get Total value
     * @return \StructType\TotalType|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \StructType\TotalType $total
     * @return \StructType\UnitRate
     */
    public function setTotal(\StructType\TotalType $total = null)
    {
        $this->Total = $total;
        return $this;
    }
}
