<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Service StructType
 * @subpackage Structs
 */
class Service extends AbstractStructBase
{
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AmountType[]
     */
    public $Price;
    /**
     * The ServiceDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResCommonDetailType
     */
    public $ServiceDetails;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The ServicePricingType
     * @var string
     */
    public $ServicePricingType;
    /**
     * The ReservationStatusType
     * @var string
     */
    public $ReservationStatusType;
    /**
     * The ServiceRPH
     * @var string
     */
    public $ServiceRPH;
    /**
     * The ServiceInventoryCode
     * @var string
     */
    public $ServiceInventoryCode;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The InventoryBlockCode
     * @var string
     */
    public $InventoryBlockCode;
    /**
     * The PriceGuaranteed
     * @var bool
     */
    public $PriceGuaranteed;
    /**
     * The Inclusive
     * @var bool
     */
    public $Inclusive;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for Service
     * @uses Service::setPrice()
     * @uses Service::setServiceDetails()
     * @uses Service::setTPA_Extensions()
     * @uses Service::setServicePricingType()
     * @uses Service::setReservationStatusType()
     * @uses Service::setServiceRPH()
     * @uses Service::setServiceInventoryCode()
     * @uses Service::setRatePlanCode()
     * @uses Service::setInventoryBlockCode()
     * @uses Service::setPriceGuaranteed()
     * @uses Service::setInclusive()
     * @uses Service::setQuantity()
     * @param \StructType\AmountType[] $price
     * @param \StructType\ResCommonDetailType $serviceDetails
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     * @param string $servicePricingType
     * @param string $reservationStatusType
     * @param string $serviceRPH
     * @param string $serviceInventoryCode
     * @param string $ratePlanCode
     * @param string $inventoryBlockCode
     * @param bool $priceGuaranteed
     * @param bool $inclusive
     * @param int $quantity
     */
    public function __construct(array $price = array(), \StructType\ResCommonDetailType $serviceDetails = null, \StructType\TPA_Extensions_Type $tPA_Extensions = null, $servicePricingType = null, $reservationStatusType = null, $serviceRPH = null, $serviceInventoryCode = null, $ratePlanCode = null, $inventoryBlockCode = null, $priceGuaranteed = null, $inclusive = null, $quantity = null)
    {
        $this
            ->setPrice($price)
            ->setServiceDetails($serviceDetails)
            ->setTPA_Extensions($tPA_Extensions)
            ->setServicePricingType($servicePricingType)
            ->setReservationStatusType($reservationStatusType)
            ->setServiceRPH($serviceRPH)
            ->setServiceInventoryCode($serviceInventoryCode)
            ->setRatePlanCode($ratePlanCode)
            ->setInventoryBlockCode($inventoryBlockCode)
            ->setPriceGuaranteed($priceGuaranteed)
            ->setInclusive($inclusive)
            ->setQuantity($quantity);
    }
    /**
     * Get Price value
     * @return \StructType\AmountType[]|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * This method is responsible for validating the values passed to the setPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceForArrayConstraintsFromSetPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $servicePriceItem) {
            // validation for constraint: itemType
            if (!$servicePriceItem instanceof \StructType\AmountType) {
                $invalidValues[] = is_object($servicePriceItem) ? get_class($servicePriceItem) : sprintf('%s(%s)', gettype($servicePriceItem), var_export($servicePriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Price property can only contain items of type \StructType\AmountType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Price value
     * @throws \InvalidArgumentException
     * @param \StructType\AmountType[] $price
     * @return \StructType\Service
     */
    public function setPrice(array $price = array())
    {
        // validation for constraint: array
        if ('' !== ($priceArrayErrorMessage = self::validatePriceForArrayConstraintsFromSetPrice($price))) {
            throw new \InvalidArgumentException($priceArrayErrorMessage, __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Add item to Price value
     * @throws \InvalidArgumentException
     * @param \StructType\AmountType $item
     * @return \StructType\Service
     */
    public function addToPrice(\StructType\AmountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AmountType) {
            throw new \InvalidArgumentException(sprintf('The Price property can only contain items of type \StructType\AmountType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Price[] = $item;
        return $this;
    }
    /**
     * Get ServiceDetails value
     * @return \StructType\ResCommonDetailType|null
     */
    public function getServiceDetails()
    {
        return $this->ServiceDetails;
    }
    /**
     * Set ServiceDetails value
     * @param \StructType\ResCommonDetailType $serviceDetails
     * @return \StructType\Service
     */
    public function setServiceDetails(\StructType\ResCommonDetailType $serviceDetails = null)
    {
        $this->ServiceDetails = $serviceDetails;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \StructType\Service
     */
    public function setTPA_Extensions(\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ServicePricingType value
     * @return string|null
     */
    public function getServicePricingType()
    {
        return $this->ServicePricingType;
    }
    /**
     * Set ServicePricingType value
     * @uses \EnumType\PricingType::valueIsValid()
     * @uses \EnumType\PricingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $servicePricingType
     * @return \StructType\Service
     */
    public function setServicePricingType($servicePricingType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PricingType::valueIsValid($servicePricingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PricingType', is_array($servicePricingType) ? implode(', ', $servicePricingType) : var_export($servicePricingType, true), implode(', ', \EnumType\PricingType::getValidValues())), __LINE__);
        }
        $this->ServicePricingType = $servicePricingType;
        return $this;
    }
    /**
     * Get ReservationStatusType value
     * @return string|null
     */
    public function getReservationStatusType()
    {
        return $this->ReservationStatusType;
    }
    /**
     * Set ReservationStatusType value
     * @uses \EnumType\PMS_ResStatusType::valueIsValid()
     * @uses \EnumType\PMS_ResStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reservationStatusType
     * @return \StructType\Service
     */
    public function setReservationStatusType($reservationStatusType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PMS_ResStatusType::valueIsValid($reservationStatusType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PMS_ResStatusType', is_array($reservationStatusType) ? implode(', ', $reservationStatusType) : var_export($reservationStatusType, true), implode(', ', \EnumType\PMS_ResStatusType::getValidValues())), __LINE__);
        }
        $this->ReservationStatusType = $reservationStatusType;
        return $this;
    }
    /**
     * Get ServiceRPH value
     * @return string|null
     */
    public function getServiceRPH()
    {
        return $this->ServiceRPH;
    }
    /**
     * Set ServiceRPH value
     * @param string $serviceRPH
     * @return \StructType\Service
     */
    public function setServiceRPH($serviceRPH = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRPH) && !is_string($serviceRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceRPH, true), gettype($serviceRPH)), __LINE__);
        }
        $this->ServiceRPH = $serviceRPH;
        return $this;
    }
    /**
     * Get ServiceInventoryCode value
     * @return string|null
     */
    public function getServiceInventoryCode()
    {
        return $this->ServiceInventoryCode;
    }
    /**
     * Set ServiceInventoryCode value
     * @param string $serviceInventoryCode
     * @return \StructType\Service
     */
    public function setServiceInventoryCode($serviceInventoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceInventoryCode) && !is_string($serviceInventoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceInventoryCode, true), gettype($serviceInventoryCode)), __LINE__);
        }
        $this->ServiceInventoryCode = $serviceInventoryCode;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\Service
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get InventoryBlockCode value
     * @return string|null
     */
    public function getInventoryBlockCode()
    {
        return $this->InventoryBlockCode;
    }
    /**
     * Set InventoryBlockCode value
     * @param string $inventoryBlockCode
     * @return \StructType\Service
     */
    public function setInventoryBlockCode($inventoryBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryBlockCode) && !is_string($inventoryBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventoryBlockCode, true), gettype($inventoryBlockCode)), __LINE__);
        }
        $this->InventoryBlockCode = $inventoryBlockCode;
        return $this;
    }
    /**
     * Get PriceGuaranteed value
     * @return bool|null
     */
    public function getPriceGuaranteed()
    {
        return $this->PriceGuaranteed;
    }
    /**
     * Set PriceGuaranteed value
     * @param bool $priceGuaranteed
     * @return \StructType\Service
     */
    public function setPriceGuaranteed($priceGuaranteed = null)
    {
        // validation for constraint: boolean
        if (!is_null($priceGuaranteed) && !is_bool($priceGuaranteed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($priceGuaranteed, true), gettype($priceGuaranteed)), __LINE__);
        }
        $this->PriceGuaranteed = $priceGuaranteed;
        return $this;
    }
    /**
     * Get Inclusive value
     * @return bool|null
     */
    public function getInclusive()
    {
        return $this->Inclusive;
    }
    /**
     * Set Inclusive value
     * @param bool $inclusive
     * @return \StructType\Service
     */
    public function setInclusive($inclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inclusive) && !is_bool($inclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inclusive, true), gettype($inclusive)), __LINE__);
        }
        $this->Inclusive = $inclusive;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\Service
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
}
