<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PreferLevelType EnumType
 * @subpackage Enumerations
 */
class PreferLevelType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Only'
     * @return string 'Only'
     */
    const VALUE_ONLY = 'Only';
    /**
     * Constant for value 'Unacceptable'
     * @return string 'Unacceptable'
     */
    const VALUE_UNACCEPTABLE = 'Unacceptable';
    /**
     * Constant for value 'Preferred'
     * @return string 'Preferred'
     */
    const VALUE_PREFERRED = 'Preferred';
    /**
     * Constant for value 'Required'
     * @return string 'Required'
     */
    const VALUE_REQUIRED = 'Required';
    /**
     * Constant for value 'NoPreference'
     * @return string 'NoPreference'
     */
    const VALUE_NO_PREFERENCE = 'NoPreference';
    /**
     * Return allowed values
     * @uses self::VALUE_ONLY
     * @uses self::VALUE_UNACCEPTABLE
     * @uses self::VALUE_PREFERRED
     * @uses self::VALUE_REQUIRED
     * @uses self::VALUE_NO_PREFERENCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ONLY,
            self::VALUE_UNACCEPTABLE,
            self::VALUE_PREFERRED,
            self::VALUE_REQUIRED,
            self::VALUE_NO_PREFERENCE,
        );
    }
}
