<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPaymentFormType ArrayType
 * @subpackage Arrays
 */
class ArrayOfPaymentFormType extends AbstractStructArrayBase
{
    /**
     * The AcceptedPayment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentFormType[]
     */
    public $AcceptedPayment;
    /**
     * Constructor method for ArrayOfPaymentFormType
     * @uses ArrayOfPaymentFormType::setAcceptedPayment()
     * @param \StructType\PaymentFormType[] $acceptedPayment
     */
    public function __construct(array $acceptedPayment = array())
    {
        $this
            ->setAcceptedPayment($acceptedPayment);
    }
    /**
     * Get AcceptedPayment value
     * @return \StructType\PaymentFormType[]|null
     */
    public function getAcceptedPayment()
    {
        return $this->AcceptedPayment;
    }
    /**
     * This method is responsible for validating the values passed to the setAcceptedPayment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcceptedPayment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAcceptedPaymentForArrayConstraintsFromSetAcceptedPayment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPaymentFormTypeAcceptedPaymentItem) {
            // validation for constraint: itemType
            if (!$arrayOfPaymentFormTypeAcceptedPaymentItem instanceof \StructType\PaymentFormType) {
                $invalidValues[] = is_object($arrayOfPaymentFormTypeAcceptedPaymentItem) ? get_class($arrayOfPaymentFormTypeAcceptedPaymentItem) : sprintf('%s(%s)', gettype($arrayOfPaymentFormTypeAcceptedPaymentItem), var_export($arrayOfPaymentFormTypeAcceptedPaymentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AcceptedPayment property can only contain items of type \StructType\PaymentFormType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AcceptedPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFormType[] $acceptedPayment
     * @return \ArrayType\ArrayOfPaymentFormType
     */
    public function setAcceptedPayment(array $acceptedPayment = array())
    {
        // validation for constraint: array
        if ('' !== ($acceptedPaymentArrayErrorMessage = self::validateAcceptedPaymentForArrayConstraintsFromSetAcceptedPayment($acceptedPayment))) {
            throw new \InvalidArgumentException($acceptedPaymentArrayErrorMessage, __LINE__);
        }
        $this->AcceptedPayment = $acceptedPayment;
        return $this;
    }
    /**
     * Add item to AcceptedPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFormType $item
     * @return \ArrayType\ArrayOfPaymentFormType
     */
    public function addToAcceptedPayment(\StructType\PaymentFormType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentFormType) {
            throw new \InvalidArgumentException(sprintf('The AcceptedPayment property can only contain items of type \StructType\PaymentFormType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AcceptedPayment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PaymentFormType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PaymentFormType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PaymentFormType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PaymentFormType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PaymentFormType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AcceptedPayment
     */
    public function getAttributeName()
    {
        return 'AcceptedPayment';
    }
}
