<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoorGroupResult StructType
 * @subpackage Structs
 */
class DoorGroupResult extends AbstractStructBase
{
    /**
     * The Error
     * Meta informations extracted from the WSDL
     * - choice: Error | DoorGroup
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\ErrorInfo
     */
    public $Error;
    /**
     * The DoorGroup
     * Meta informations extracted from the WSDL
     * - choice: Error | DoorGroup
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DoorGroup
     */
    public $DoorGroup;
    /**
     * Constructor method for DoorGroupResult
     * @uses DoorGroupResult::setError()
     * @uses DoorGroupResult::setDoorGroup()
     * @param \StructType\ErrorInfo $error
     * @param \StructType\DoorGroup $doorGroup
     */
    public function __construct(\StructType\ErrorInfo $error = null, \StructType\DoorGroup $doorGroup = null)
    {
        $this
            ->setError($error)
            ->setDoorGroup($doorGroup);
    }
    /**
     * Get Error value
     * @return \StructType\ErrorInfo|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * This method is responsible for validating the value passed to the setError method
     * This method is willingly generated in order to preserve the one-line inline validation within the setError method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErrorForChoiceConstraintsFromSetError($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DoorGroup',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Error can\'t be set as the property %s is already set. Only one property must be set among these properties: Error, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Error value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorInfo $error
     * @return \StructType\DoorGroupResult
     */
    public function setError(\StructType\ErrorInfo $error = null)
    {
        // validation for constraint: choice(Error, DoorGroup)
        if ('' !== ($errorChoiceErrorMessage = self::validateErrorForChoiceConstraintsFromSetError($error))) {
            throw new \InvalidArgumentException($errorChoiceErrorMessage, __LINE__);
        }
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get DoorGroup value
     * @return \StructType\DoorGroup|null
     */
    public function getDoorGroup()
    {
        return isset($this->DoorGroup) ? $this->DoorGroup : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDoorGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDoorGroup method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDoorGroupForChoiceConstraintsFromSetDoorGroup($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Error',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DoorGroup can\'t be set as the property %s is already set. Only one property must be set among these properties: DoorGroup, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DoorGroup value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DoorGroup $doorGroup
     * @return \StructType\DoorGroupResult
     */
    public function setDoorGroup(\StructType\DoorGroup $doorGroup = null)
    {
        // validation for constraint: choice(Error, DoorGroup)
        if ('' !== ($doorGroupChoiceErrorMessage = self::validateDoorGroupForChoiceConstraintsFromSetDoorGroup($doorGroup))) {
            throw new \InvalidArgumentException($doorGroupChoiceErrorMessage, __LINE__);
        }
        if (is_null($doorGroup) || (is_array($doorGroup) && empty($doorGroup))) {
            unset($this->DoorGroup);
        } else {
            $this->DoorGroup = $doorGroup;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DoorGroupResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
