<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoorGroupList StructType
 * @subpackage Structs
 */
class DoorGroupList extends AbstractStructBase
{
    /**
     * The DoorGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DoorGroup[]
     */
    public $DoorGroup;
    /**
     * Constructor method for DoorGroupList
     * @uses DoorGroupList::setDoorGroup()
     * @param \StructType\DoorGroup[] $doorGroup
     */
    public function __construct(array $doorGroup = array())
    {
        $this
            ->setDoorGroup($doorGroup);
    }
    /**
     * Get DoorGroup value
     * @return \StructType\DoorGroup[]|null
     */
    public function getDoorGroup()
    {
        return $this->DoorGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setDoorGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDoorGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDoorGroupForArrayConstraintsFromSetDoorGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $doorGroupListDoorGroupItem) {
            // validation for constraint: itemType
            if (!$doorGroupListDoorGroupItem instanceof \StructType\DoorGroup) {
                $invalidValues[] = is_object($doorGroupListDoorGroupItem) ? get_class($doorGroupListDoorGroupItem) : sprintf('%s(%s)', gettype($doorGroupListDoorGroupItem), var_export($doorGroupListDoorGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DoorGroup property can only contain items of type \StructType\DoorGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DoorGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\DoorGroup[] $doorGroup
     * @return \StructType\DoorGroupList
     */
    public function setDoorGroup(array $doorGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($doorGroupArrayErrorMessage = self::validateDoorGroupForArrayConstraintsFromSetDoorGroup($doorGroup))) {
            throw new \InvalidArgumentException($doorGroupArrayErrorMessage, __LINE__);
        }
        $this->DoorGroup = $doorGroup;
        return $this;
    }
    /**
     * Add item to DoorGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\DoorGroup $item
     * @return \StructType\DoorGroupList
     */
    public function addToDoorGroup(\StructType\DoorGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DoorGroup) {
            throw new \InvalidArgumentException(sprintf('The DoorGroup property can only contain items of type \StructType\DoorGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DoorGroup[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DoorGroupList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
