<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Site StructType
 * @subpackage Structs
 */
class Site extends AbstractStructBase
{
    /**
     * The Site
     * @var \StructType\Site
     */
    public $Site;
    /**
     * The Door
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Door[]
     */
    public $Door;
    /**
     * The DoorGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DoorGroup[]
     */
    public $DoorGroup;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - base: int
     * - maxInclusive: 65535
     * @var int
     */
    public $Id;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - base: string
     * - maxLength: 200
     * @var string
     */
    public $Name;
    /**
     * Constructor method for Site
     * @uses Site::setSite()
     * @uses Site::setDoor()
     * @uses Site::setDoorGroup()
     * @uses Site::setId()
     * @uses Site::setName()
     * @param \StructType\Site $site
     * @param \StructType\Door[] $door
     * @param \StructType\DoorGroup[] $doorGroup
     * @param int $id
     * @param string $name
     */
    public function __construct(\StructType\Site $site = null, array $door = array(), array $doorGroup = array(), $id = null, $name = null)
    {
        $this
            ->setSite($site)
            ->setDoor($door)
            ->setDoorGroup($doorGroup)
            ->setId($id)
            ->setName($name);
    }
    /**
     * Get Site value
     * @return \StructType\Site|null
     */
    public function getSite()
    {
        return $this->Site;
    }
    /**
     * Set Site value
     * @param \StructType\Site $site
     * @return \StructType\Site
     */
    public function setSite(\StructType\Site $site = null)
    {
        $this->Site = $site;
        return $this;
    }
    /**
     * Get Door value
     * @return \StructType\Door[]|null
     */
    public function getDoor()
    {
        return $this->Door;
    }
    /**
     * This method is responsible for validating the values passed to the setDoor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDoor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDoorForArrayConstraintsFromSetDoor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $siteDoorItem) {
            // validation for constraint: itemType
            if (!$siteDoorItem instanceof \StructType\Door) {
                $invalidValues[] = is_object($siteDoorItem) ? get_class($siteDoorItem) : sprintf('%s(%s)', gettype($siteDoorItem), var_export($siteDoorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Door property can only contain items of type \StructType\Door, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Door value
     * @throws \InvalidArgumentException
     * @param \StructType\Door[] $door
     * @return \StructType\Site
     */
    public function setDoor(array $door = array())
    {
        // validation for constraint: array
        if ('' !== ($doorArrayErrorMessage = self::validateDoorForArrayConstraintsFromSetDoor($door))) {
            throw new \InvalidArgumentException($doorArrayErrorMessage, __LINE__);
        }
        $this->Door = $door;
        return $this;
    }
    /**
     * Add item to Door value
     * @throws \InvalidArgumentException
     * @param \StructType\Door $item
     * @return \StructType\Site
     */
    public function addToDoor(\StructType\Door $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Door) {
            throw new \InvalidArgumentException(sprintf('The Door property can only contain items of type \StructType\Door, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Door[] = $item;
        return $this;
    }
    /**
     * Get DoorGroup value
     * @return \StructType\DoorGroup[]|null
     */
    public function getDoorGroup()
    {
        return $this->DoorGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setDoorGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDoorGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDoorGroupForArrayConstraintsFromSetDoorGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $siteDoorGroupItem) {
            // validation for constraint: itemType
            if (!$siteDoorGroupItem instanceof \StructType\DoorGroup) {
                $invalidValues[] = is_object($siteDoorGroupItem) ? get_class($siteDoorGroupItem) : sprintf('%s(%s)', gettype($siteDoorGroupItem), var_export($siteDoorGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DoorGroup property can only contain items of type \StructType\DoorGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DoorGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\DoorGroup[] $doorGroup
     * @return \StructType\Site
     */
    public function setDoorGroup(array $doorGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($doorGroupArrayErrorMessage = self::validateDoorGroupForArrayConstraintsFromSetDoorGroup($doorGroup))) {
            throw new \InvalidArgumentException($doorGroupArrayErrorMessage, __LINE__);
        }
        $this->DoorGroup = $doorGroup;
        return $this;
    }
    /**
     * Add item to DoorGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\DoorGroup $item
     * @return \StructType\Site
     */
    public function addToDoorGroup(\StructType\DoorGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DoorGroup) {
            throw new \InvalidArgumentException(sprintf('The DoorGroup property can only contain items of type \StructType\DoorGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DoorGroup[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\Site
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxInclusive(65535)
        if (!is_null($id) && $id > 65535) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 65535', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Site
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($name) && mb_strlen($name) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Site
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
