<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchRange StructType
 * @subpackage Structs
 */
class SearchRange extends AbstractStructBase
{
    /**
     * The startRecordNo
     * @var int
     */
    public $startRecordNo;
    /**
     * The nrOfRecords
     * Meta informations extracted from the WSDL
     * - base: int
     * - maxInclusive: 1000
     * - minOccurs: 0
     * @var int
     */
    public $nrOfRecords;
    /**
     * Constructor method for SearchRange
     * @uses SearchRange::setStartRecordNo()
     * @uses SearchRange::setNrOfRecords()
     * @param int $startRecordNo
     * @param int $nrOfRecords
     */
    public function __construct($startRecordNo = null, $nrOfRecords = null)
    {
        $this
            ->setStartRecordNo($startRecordNo)
            ->setNrOfRecords($nrOfRecords);
    }
    /**
     * Get startRecordNo value
     * @return int|null
     */
    public function getStartRecordNo()
    {
        return $this->startRecordNo;
    }
    /**
     * Set startRecordNo value
     * @param int $startRecordNo
     * @return \StructType\SearchRange
     */
    public function setStartRecordNo($startRecordNo = null)
    {
        // validation for constraint: int
        if (!is_null($startRecordNo) && !(is_int($startRecordNo) || ctype_digit($startRecordNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startRecordNo, true), gettype($startRecordNo)), __LINE__);
        }
        $this->startRecordNo = $startRecordNo;
        return $this;
    }
    /**
     * Get nrOfRecords value
     * @return int|null
     */
    public function getNrOfRecords()
    {
        return $this->nrOfRecords;
    }
    /**
     * Set nrOfRecords value
     * @param int $nrOfRecords
     * @return \StructType\SearchRange
     */
    public function setNrOfRecords($nrOfRecords = null)
    {
        // validation for constraint: int
        if (!is_null($nrOfRecords) && !(is_int($nrOfRecords) || ctype_digit($nrOfRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nrOfRecords, true), gettype($nrOfRecords)), __LINE__);
        }
        // validation for constraint: maxInclusive(1000)
        if (!is_null($nrOfRecords) && $nrOfRecords > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 1000', var_export($nrOfRecords, true)), __LINE__);
        }
        $this->nrOfRecords = $nrOfRecords;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchRange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
