<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Door ServiceType
 */
$door = new \ServiceType\Door($options);
/**
 * Sample call for DoorSearch operation/method
 */
if ($door->DoorSearch(new \StructType\DoorSearch()) !== false) {
    print_r($door->getResult());
} else {
    print_r($door->getLastError());
}
/**
 * Sample call for DoorAdd operation/method
 */
if ($door->DoorAdd(new \StructType\Door()) !== false) {
    print_r($door->getResult());
} else {
    print_r($door->getLastError());
}
/**
 * Sample call for DoorChange operation/method
 */
if ($door->DoorChange(new \StructType\DoorChange()) !== false) {
    print_r($door->getResult());
} else {
    print_r($door->getLastError());
}
/**
 * Sample call for DoorRemove operation/method
 */
if ($door->DoorRemove($id) !== false) {
    print_r($door->getResult());
} else {
    print_r($door->getLastError());
}
/**
 * Sample call for DoorGroupSearch operation/method
 */
if ($door->DoorGroupSearch(new \StructType\DoorGroupSearch()) !== false) {
    print_r($door->getResult());
} else {
    print_r($door->getLastError());
}
/**
 * Sample call for DoorGroupAdd operation/method
 */
if ($door->DoorGroupAdd(new \StructType\DoorGroup()) !== false) {
    print_r($door->getResult());
} else {
    print_r($door->getLastError());
}
/**
 * Sample call for DoorGroupChange operation/method
 */
if ($door->DoorGroupChange(new \StructType\DoorGroupChange()) !== false) {
    print_r($door->getResult());
} else {
    print_r($door->getLastError());
}
/**
 * Sample call for DoorGroupRemove operation/method
 */
if ($door->DoorGroupRemove($id) !== false) {
    print_r($door->getResult());
} else {
    print_r($door->getLastError());
}
/**
 * Samples for Configuration ServiceType
 */
$configuration = new \ServiceType\Configuration($options);
/**
 * Sample call for ConfigurationSearch operation/method
 */
if ($configuration->ConfigurationSearch(new \StructType\ConfigurationSearch()) !== false) {
    print_r($configuration->getResult());
} else {
    print_r($configuration->getLastError());
}
/**
 * Samples for Site ServiceType
 */
$site = new \ServiceType\Site($options);
/**
 * Sample call for SiteSearch operation/method
 */
if ($site->SiteSearch(new \StructType\SiteSearch()) !== false) {
    print_r($site->getResult());
} else {
    print_r($site->getLastError());
}
