<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Status StructType
 * @subpackage Structs
 */
class Status extends AbstractStructBase
{
    /**
     * The Ok
     * Meta informations extracted from the WSDL
     * - base: string
     * - choice: Ok | Error
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 200
     * @var string
     */
    public $Ok;
    /**
     * The Error
     * Meta informations extracted from the WSDL
     * - choice: Ok | Error
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\ErrorInfo
     */
    public $Error;
    /**
     * Constructor method for Status
     * @uses Status::setOk()
     * @uses Status::setError()
     * @param string $ok
     * @param \StructType\ErrorInfo $error
     */
    public function __construct($ok = null, \StructType\ErrorInfo $error = null)
    {
        $this
            ->setOk($ok)
            ->setError($error);
    }
    /**
     * Get Ok value
     * @return string|null
     */
    public function getOk()
    {
        return isset($this->Ok) ? $this->Ok : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOk method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOk method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOkForChoiceConstraintsFromSetOk($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Error',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Ok can\'t be set as the property %s is already set. Only one property must be set among these properties: Ok, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Ok value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $ok
     * @return \StructType\Status
     */
    public function setOk($ok = null)
    {
        // validation for constraint: string
        if (!is_null($ok) && !is_string($ok)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ok, true), gettype($ok)), __LINE__);
        }
        // validation for constraint: choice(Ok, Error)
        if ('' !== ($okChoiceErrorMessage = self::validateOkForChoiceConstraintsFromSetOk($ok))) {
            throw new \InvalidArgumentException($okChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($ok) && mb_strlen($ok) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($ok)), __LINE__);
        }
        if (is_null($ok) || (is_array($ok) && empty($ok))) {
            unset($this->Ok);
        } else {
            $this->Ok = $ok;
        }
        return $this;
    }
    /**
     * Get Error value
     * @return \StructType\ErrorInfo|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * This method is responsible for validating the value passed to the setError method
     * This method is willingly generated in order to preserve the one-line inline validation within the setError method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErrorForChoiceConstraintsFromSetError($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Ok',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Error can\'t be set as the property %s is already set. Only one property must be set among these properties: Error, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Error value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorInfo $error
     * @return \StructType\Status
     */
    public function setError(\StructType\ErrorInfo $error = null)
    {
        // validation for constraint: choice(Ok, Error)
        if ('' !== ($errorChoiceErrorMessage = self::validateErrorForChoiceConstraintsFromSetError($error))) {
            throw new \InvalidArgumentException($errorChoiceErrorMessage, __LINE__);
        }
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Status
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
