<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoorResult StructType
 * @subpackage Structs
 */
class DoorResult extends AbstractStructBase
{
    /**
     * The Error
     * Meta informations extracted from the WSDL
     * - choice: Error | Door
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\ErrorInfo
     */
    public $Error;
    /**
     * The Door
     * Meta informations extracted from the WSDL
     * - choice: Error | Door
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Door
     */
    public $Door;
    /**
     * Constructor method for DoorResult
     * @uses DoorResult::setError()
     * @uses DoorResult::setDoor()
     * @param \StructType\ErrorInfo $error
     * @param \StructType\Door $door
     */
    public function __construct(\StructType\ErrorInfo $error = null, \StructType\Door $door = null)
    {
        $this
            ->setError($error)
            ->setDoor($door);
    }
    /**
     * Get Error value
     * @return \StructType\ErrorInfo|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * This method is responsible for validating the value passed to the setError method
     * This method is willingly generated in order to preserve the one-line inline validation within the setError method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErrorForChoiceConstraintsFromSetError($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Door',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Error can\'t be set as the property %s is already set. Only one property must be set among these properties: Error, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Error value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorInfo $error
     * @return \StructType\DoorResult
     */
    public function setError(\StructType\ErrorInfo $error = null)
    {
        // validation for constraint: choice(Error, Door)
        if ('' !== ($errorChoiceErrorMessage = self::validateErrorForChoiceConstraintsFromSetError($error))) {
            throw new \InvalidArgumentException($errorChoiceErrorMessage, __LINE__);
        }
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get Door value
     * @return \StructType\Door|null
     */
    public function getDoor()
    {
        return isset($this->Door) ? $this->Door : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDoor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDoor method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDoorForChoiceConstraintsFromSetDoor($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Error',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Door can\'t be set as the property %s is already set. Only one property must be set among these properties: Door, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Door value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Door $door
     * @return \StructType\DoorResult
     */
    public function setDoor(\StructType\Door $door = null)
    {
        // validation for constraint: choice(Error, Door)
        if ('' !== ($doorChoiceErrorMessage = self::validateDoorForChoiceConstraintsFromSetDoor($door))) {
            throw new \InvalidArgumentException($doorChoiceErrorMessage, __LINE__);
        }
        if (is_null($door) || (is_array($door) && empty($door))) {
            unset($this->Door);
        } else {
            $this->Door = $door;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DoorResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
