<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Door ServiceType
 * @subpackage Services
 */
class Door extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DoorSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DoorSearch $search
     * @return \StructType\DoorList|bool
     */
    public function DoorSearch(\StructType\DoorSearch $search)
    {
        try {
            $this->setResult(self::getSoapClient()->DoorSearch($search));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DoorAdd
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Door $item
     * @return \StructType\DoorResult|bool
     */
    public function DoorAdd(\StructType\Door $item)
    {
        try {
            $this->setResult(self::getSoapClient()->DoorAdd($item));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DoorChange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DoorChange $item
     * @return \StructType\DoorResult|bool
     */
    public function DoorChange(\StructType\DoorChange $item)
    {
        try {
            $this->setResult(self::getSoapClient()->DoorChange($item));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DoorRemove
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $id
     * @return \StructType\Status|bool
     */
    public function DoorRemove($id)
    {
        try {
            $this->setResult(self::getSoapClient()->DoorRemove($id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DoorGroupSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DoorGroupSearch $search
     * @return \StructType\DoorGroupList|bool
     */
    public function DoorGroupSearch(\StructType\DoorGroupSearch $search)
    {
        try {
            $this->setResult(self::getSoapClient()->DoorGroupSearch($search));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DoorGroupAdd
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DoorGroup $item
     * @return \StructType\DoorGroupResult|bool
     */
    public function DoorGroupAdd(\StructType\DoorGroup $item)
    {
        try {
            $this->setResult(self::getSoapClient()->DoorGroupAdd($item));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DoorGroupChange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DoorGroupChange $item
     * @return \StructType\DoorGroupResult|bool
     */
    public function DoorGroupChange(\StructType\DoorGroupChange $item)
    {
        try {
            $this->setResult(self::getSoapClient()->DoorGroupChange($item));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DoorGroupRemove
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $id
     * @return \StructType\Status|bool
     */
    public function DoorGroupRemove($id)
    {
        try {
            $this->setResult(self::getSoapClient()->DoorGroupRemove($id));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DoorGroupList|\StructType\DoorGroupResult|\StructType\DoorList|\StructType\DoorResult|\StructType\Status
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
