<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Configuration ServiceType
 * @subpackage Services
 */
class Configuration extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ConfigurationSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConfigurationSearch $item
     * @return \StructType\Configuration|bool
     */
    public function ConfigurationSearch(\StructType\ConfigurationSearch $item)
    {
        try {
            $this->setResult(self::getSoapClient()->ConfigurationSearch($item));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Configuration
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
