<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://service.mngkargo.com.tr/musterikargodurumu.service/musterikargodurumu.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://service.mngkargo.com.tr/musterikargodurumu.service/musterikargodurumu.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Musteri ServiceType
 */
$musteri = new \ServiceType\Musteri($options);
/**
 * Sample call for MusteriKargoTakipByFatura operation/method
 */
if ($musteri->MusteriKargoTakipByFatura(new \StructType\MusteriKargoTakipByFatura()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriKargoTakipBySiparis operation/method
 */
if ($musteri->MusteriKargoTakipBySiparis(new \StructType\MusteriKargoTakipBySiparis()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriKargoTakipByTopluFatura operation/method
 */
if ($musteri->MusteriKargoTakipByTopluFatura(new \StructType\MusteriKargoTakipByTopluFatura()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriKargoBilgiByTopluFatura operation/method
 */
if ($musteri->MusteriKargoBilgiByTopluFatura(new \StructType\MusteriKargoBilgiByTopluFatura()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriKargoTakipByIrsaliyeNo operation/method
 */
if ($musteri->MusteriKargoTakipByIrsaliyeNo(new \StructType\MusteriKargoTakipByIrsaliyeNo()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriKargoTakipByTarih operation/method
 */
if ($musteri->MusteriKargoTakipByTarih(new \StructType\MusteriKargoTakipByTarih()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriKargoTakipByBarkod operation/method
 */
if ($musteri->MusteriKargoTakipByBarkod(new \StructType\MusteriKargoTakipByBarkod()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriKargoBilgileriByBarkod operation/method
 */
if ($musteri->MusteriKargoBilgileriByBarkod(new \StructType\MusteriKargoBilgileriByBarkod()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriKargoBilgileri operation/method
 */
if ($musteri->MusteriKargoBilgileri(new \StructType\MusteriKargoBilgileri()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriAtfBilgileri operation/method
 */
if ($musteri->MusteriAtfBilgileri(new \StructType\MusteriAtfBilgileri()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriKargoTakipByBayino operation/method
 */
if ($musteri->MusteriKargoTakipByBayino(new \StructType\MusteriKargoTakipByBayino()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriIadeKargoTakip operation/method
 */
if ($musteri->MusteriIadeKargoTakip(new \StructType\MusteriIadeKargoTakip()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriKargoBilgiFace operation/method
 */
if ($musteri->MusteriKargoBilgiFace(new \StructType\MusteriKargoBilgiFace()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriKargoTakipFace operation/method
 */
if ($musteri->MusteriKargoTakipFace(new \StructType\MusteriKargoTakipFace()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriHizmetleriFace operation/method
 */
if ($musteri->MusteriHizmetleriFace(new \StructType\MusteriHizmetleriFace()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriIadeKargoTakipByTarih operation/method
 */
if ($musteri->MusteriIadeKargoTakipByTarih(new \StructType\MusteriIadeKargoTakipByTarih()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriKargoTakipByParcaIcerikTakipNo operation/method
 */
if ($musteri->MusteriKargoTakipByParcaIcerikTakipNo(new \StructType\MusteriKargoTakipByParcaIcerikTakipNo()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Sample call for MusteriKargoBilgileriBySiparisNo operation/method
 */
if ($musteri->MusteriKargoBilgileriBySiparisNo(new \StructType\MusteriKargoBilgileriBySiparisNo()) !== false) {
    print_r($musteri->getResult());
} else {
    print_r($musteri->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetAllIl operation/method
 */
if ($get->GetAllIl(new \StructType\GetAllIl()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetIlceByIlId operation/method
 */
if ($get->GetIlceByIlId(new \StructType\GetIlceByIlId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSubeByIlIlce operation/method
 */
if ($get->GetSubeByIlIlce(new \StructType\GetSubeByIlIlce()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Kargo ServiceType
 */
$kargo = new \ServiceType\Kargo($options);
/**
 * Sample call for KargoUcretHesaplaFace operation/method
 */
if ($kargo->KargoUcretHesaplaFace(new \StructType\KargoUcretHesaplaFace()) !== false) {
    print_r($kargo->getResult());
} else {
    print_r($kargo->getLastError());
}
/**
 * Samples for Kurye ServiceType
 */
$kurye = new \ServiceType\Kurye($options);
/**
 * Sample call for KuryeCagirFace operation/method
 */
if ($kurye->KuryeCagirFace(new \StructType\KuryeCagirFace()) !== false) {
    print_r($kurye->getResult());
} else {
    print_r($kurye->getLastError());
}
/**
 * Samples for Teslim ServiceType
 */
$teslim = new \ServiceType\Teslim($options);
/**
 * Sample call for TeslimEdilenGonderiListesi operation/method
 */
if ($teslim->TeslimEdilenGonderiListesi(new \StructType\TeslimEdilenKargolar()) !== false) {
    print_r($teslim->getResult());
} else {
    print_r($teslim->getLastError());
}
/**
 * Samples for Mal ServiceType
 */
$mal = new \ServiceType\Mal($options);
/**
 * Sample call for MalBedelliGonderiKomisyonFaturaListesi operation/method
 */
if ($mal->MalBedelliGonderiKomisyonFaturaListesi(new \StructType\MalBedelliGonderiKomisyonFaturaListesi()) !== false) {
    print_r($mal->getResult());
} else {
    print_r($mal->getLastError());
}
/**
 * Sample call for MalBedelliGonderiKomisyonFaturaDetay operation/method
 */
if ($mal->MalBedelliGonderiKomisyonFaturaDetay(new \StructType\MalBedelliGonderiKomisyonFaturaDetay()) !== false) {
    print_r($mal->getResult());
} else {
    print_r($mal->getLastError());
}
/**
 * Samples for Gonderi ServiceType
 */
$gonderi = new \ServiceType\Gonderi($options);
/**
 * Sample call for GonderiSonDurumlari operation/method
 */
if ($gonderi->GonderiSonDurumlari(new \StructType\GonderiSonDurumlari()) !== false) {
    print_r($gonderi->getResult());
} else {
    print_r($gonderi->getLastError());
}
/**
 * Samples for Fatura ServiceType
 */
$fatura = new \ServiceType\Fatura($options);
/**
 * Sample call for FaturaSiparisBilgiTz operation/method
 */
if ($fatura->FaturaSiparisBilgiTz(new \StructType\FaturaSiparisBilgiTz()) !== false) {
    print_r($fatura->getResult());
} else {
    print_r($fatura->getLastError());
}
