<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Musteri ServiceType
 * @subpackage Services
 */
class Musteri extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MusteriKargoTakipByFatura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriKargoTakipByFatura $parameters
     * @return \StructType\MusteriKargoTakipByFaturaResponse|bool
     */
    public function MusteriKargoTakipByFatura(\StructType\MusteriKargoTakipByFatura $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriKargoTakipByFatura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriKargoTakipBySiparis
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriKargoTakipBySiparis $parameters
     * @return \StructType\MusteriKargoTakipBySiparisResponse|bool
     */
    public function MusteriKargoTakipBySiparis(\StructType\MusteriKargoTakipBySiparis $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriKargoTakipBySiparis($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriKargoTakipByTopluFatura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriKargoTakipByTopluFatura $parameters
     * @return \StructType\MusteriKargoTakipByTopluFaturaResponse|bool
     */
    public function MusteriKargoTakipByTopluFatura(\StructType\MusteriKargoTakipByTopluFatura $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriKargoTakipByTopluFatura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriKargoBilgiByTopluFatura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriKargoBilgiByTopluFatura $parameters
     * @return \StructType\MusteriKargoBilgiByTopluFaturaResponse|bool
     */
    public function MusteriKargoBilgiByTopluFatura(\StructType\MusteriKargoBilgiByTopluFatura $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriKargoBilgiByTopluFatura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriKargoTakipByIrsaliyeNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriKargoTakipByIrsaliyeNo $parameters
     * @return \StructType\MusteriKargoTakipByIrsaliyeNoResponse|bool
     */
    public function MusteriKargoTakipByIrsaliyeNo(\StructType\MusteriKargoTakipByIrsaliyeNo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriKargoTakipByIrsaliyeNo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriKargoTakipByTarih
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriKargoTakipByTarih $parameters
     * @return \StructType\MusteriKargoTakipByTarihResponse|bool
     */
    public function MusteriKargoTakipByTarih(\StructType\MusteriKargoTakipByTarih $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriKargoTakipByTarih($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriKargoTakipByBarkod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriKargoTakipByBarkod $parameters
     * @return \StructType\MusteriKargoTakipByBarkodResponse|bool
     */
    public function MusteriKargoTakipByBarkod(\StructType\MusteriKargoTakipByBarkod $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriKargoTakipByBarkod($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriKargoBilgileriByBarkod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriKargoBilgileriByBarkod $parameters
     * @return \StructType\MusteriKargoBilgileriByBarkodResponse|bool
     */
    public function MusteriKargoBilgileriByBarkod(\StructType\MusteriKargoBilgileriByBarkod $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriKargoBilgileriByBarkod($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriKargoBilgileri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriKargoBilgileri $parameters
     * @return \StructType\MusteriKargoBilgileriResponse|bool
     */
    public function MusteriKargoBilgileri(\StructType\MusteriKargoBilgileri $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriKargoBilgileri($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriAtfBilgileri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriAtfBilgileri $parameters
     * @return \StructType\MusteriAtfBilgileriResponse|bool
     */
    public function MusteriAtfBilgileri(\StructType\MusteriAtfBilgileri $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriAtfBilgileri($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriKargoTakipByBayino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriKargoTakipByBayino $parameters
     * @return \StructType\MusteriKargoTakipByBayinoResponse|bool
     */
    public function MusteriKargoTakipByBayino(\StructType\MusteriKargoTakipByBayino $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriKargoTakipByBayino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriIadeKargoTakip
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriIadeKargoTakip $parameters
     * @return \StructType\MusteriIadeKargoTakipResponse|bool
     */
    public function MusteriIadeKargoTakip(\StructType\MusteriIadeKargoTakip $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriIadeKargoTakip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriKargoBilgiFace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriKargoBilgiFace $parameters
     * @return \StructType\MusteriKargoBilgiFaceResponse|bool
     */
    public function MusteriKargoBilgiFace(\StructType\MusteriKargoBilgiFace $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriKargoBilgiFace($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriKargoTakipFace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriKargoTakipFace $parameters
     * @return \StructType\MusteriKargoTakipFaceResponse|bool
     */
    public function MusteriKargoTakipFace(\StructType\MusteriKargoTakipFace $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriKargoTakipFace($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriHizmetleriFace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriHizmetleriFace $parameters
     * @return \StructType\MusteriHizmetleriFaceResponse|bool
     */
    public function MusteriHizmetleriFace(\StructType\MusteriHizmetleriFace $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriHizmetleriFace($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriIadeKargoTakipByTarih
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriIadeKargoTakipByTarih $parameters
     * @return \StructType\MusteriIadeKargoTakipByTarihResponse|bool
     */
    public function MusteriIadeKargoTakipByTarih(\StructType\MusteriIadeKargoTakipByTarih $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriIadeKargoTakipByTarih($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * MusteriKargoTakipByParcaIcerikTakipNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriKargoTakipByParcaIcerikTakipNo $parameters
     * @return \StructType\MusteriKargoTakipByParcaIcerikTakipNoResponse|bool
     */
    public function MusteriKargoTakipByParcaIcerikTakipNo(\StructType\MusteriKargoTakipByParcaIcerikTakipNo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriKargoTakipByParcaIcerikTakipNo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MusteriKargoBilgileriBySiparisNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MusteriKargoBilgileriBySiparisNo $parameters
     * @return \StructType\MusteriKargoBilgileriBySiparisNoResponse|bool
     */
    public function MusteriKargoBilgileriBySiparisNo(\StructType\MusteriKargoBilgileriBySiparisNo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MusteriKargoBilgileriBySiparisNo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MusteriAtfBilgileriResponse|\StructType\MusteriHizmetleriFaceResponse|\StructType\MusteriIadeKargoTakipByTarihResponse|\StructType\MusteriIadeKargoTakipResponse|\StructType\MusteriKargoBilgiByTopluFaturaResponse|\StructType\MusteriKargoBilgiFaceResponse|\StructType\MusteriKargoBilgileriByBarkodResponse|\StructType\MusteriKargoBilgileriBySiparisNoResponse|\StructType\MusteriKargoBilgileriResponse|\StructType\MusteriKargoTakipByBarkodResponse|\StructType\MusteriKargoTakipByBayinoResponse|\StructType\MusteriKargoTakipByFaturaResponse|\StructType\MusteriKargoTakipByIrsaliyeNoResponse|\StructType\MusteriKargoTakipByParcaIcerikTakipNoResponse|\StructType\MusteriKargoTakipBySiparisResponse|\StructType\MusteriKargoTakipByTarihResponse|\StructType\MusteriKargoTakipByTopluFaturaResponse|\StructType\MusteriKargoTakipFaceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
