<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Teslim ServiceType
 * @subpackage Services
 */
class Teslim extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TeslimEdilenGonderiListesi
     * Meta informations extracted from the WSDL
     * - documentation: İki tarih arasında teslim edilen kargolarınızı listeler.Son 90 gün için geçerlidir. | İki tarih arasında teslim edilen kargolarınızı listeler.Son 90 gün için geçerlidir.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TeslimEdilenKargolar $parameters
     * @return \StructType\TeslimEdilenKargolarResponse|bool
     */
    public function TeslimEdilenGonderiListesi(\StructType\TeslimEdilenKargolar $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->TeslimEdilenGonderiListesi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TeslimEdilenKargolarResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
