<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetAllIl
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllIl $parameters
     * @return \StructType\GetAllIlResponse|bool
     */
    public function GetAllIl(\StructType\GetAllIl $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllIl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetIlceByIlId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetIlceByIlId $parameters
     * @return \StructType\GetIlceByIlIdResponse|bool
     */
    public function GetIlceByIlId(\StructType\GetIlceByIlId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetIlceByIlId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSubeByIlIlce
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSubeByIlIlce $parameters
     * @return \StructType\GetSubeByIlIlceResponse|bool
     */
    public function GetSubeByIlIlce(\StructType\GetSubeByIlIlce $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSubeByIlIlce($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAllIlResponse|\StructType\GetIlceByIlIdResponse|\StructType\GetSubeByIlIlceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
